#
/* name:
	clockint

function:
	to process clock interrupts

algorithm:
	update the display register
	advance the system clock appropriately
	arrange for the next clock interrupt
	handle any callouts

parameters:

returns:

globals:
	time	(the system time of day)
	comm_blk
		clk_counter
		time_counter
		clk_want
	callout

calls:
	k_display
	fword and fuword
	any callout routines

called by:
	drainq

history:
	designed and coded by Mark Kampe
*/
#define true 0177777
#define false 000000
#define then  /* */

#include "../../shared/constants.h"
#include "../../shared/shared.h"
#include "../param.h"

int time[];


clockint()
{	register int i;
	register struct callo *p1, *p2;

/*	update the display register */
	i = k_display( _READ_ACCESS , 0 );
	if (i&01)	/* use user space */
		then i = fuword( i&0177776 );
		else i = fword( i&0177776 );
	k_display( _WRITE_ACCESS , i );


/*	update the clock appropriately	*/
tick:	if (comm_blk->c_time_counter < HZ) then goto out;
	comm_blk->c_time_counter =- HZ;
	if (++time[1] == 0) 
		then time[0]++;

/*	arrange for the next clock interrupt */
out:	comm_blk->c_clk_want = true;
	comm_blk->c_clk_counter = -(HZ/2);
	return;


/*	check for any due callouts	*/
/* FIX me to check for callouts, and impliment timeout  */
/* give some thought how to impliment this without undue cost in terms of
   interrupts */
}
