/*
 * Used to dissect integer device code
 * into major (driver designation) and
 * minor (driver parameter) parts.
 */
struct
{
	char	d_minor;
	char	d_major;
};



/*
 * Character device switch.
 */
struct	cdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_sgtty)();
} cdevsw[];

/*
 * interrupt vectoring table
 *	indexed by major device number
 */
struct	intrtab
{	int	(*d_iintr)();
	int	(*d_ointr)();
}	intrtab[];

int	nchrdev;	/* set by cinit to number of character devices */
