#
#include "../param.h"
#include "../user.h"
#include "../reg.h"
#include "../systm.h"
#include "../inode.h"

#define then /* */

/*	this code, if copied into user space and jumped to, will do an
	exec on /bin/sh
*/
int bootcode[]
{	/* 000000: */	0104413,	/*	sys exec;	*/
	/* 000002: */	0000014,	/*	sh;		*/
	/* 000004: */	0000010,	/* 	shp;		*/
	/* 000006: */	0000777,	/*	br .		*/
	/* 000010: */	0000014,	/* shp: sh;		*/
	/* 000012: */	0000000,	/*	0;		*/
	/* 000014: */	0065457,	/* sh:	</k>;		*/
	/* 000016: */	0064544,	/*	<di>;		*/
	/* 000020: */	0027562,	/*	<r/>;		*/
	/* 000022: */	0064163,	/*	<sh>;		*/
	/* 000024: */	0000000,
};

/*	userboot	- put code in the user's space so he will exec shell */
userboot()
{
	copyout( bootcode, 0, sizeof bootcode );
	u.u_ar0[R7] = 0;
}

/*
 * exec system call.
 */

exec()
{	register c, *ip;
	register char *cp;
	int bp;
	int ap, na, nc, sep;
	int framex, nlargesegs;
	extern uchar;

	/* find the file the guy is talking about */
	ip = namei( &uchar, 0 );
	if (ip == NULL)
		then return;

/* FIX exec to buy a segment for arguments, discard scratchpage */
	bp = scratchpage;
	if (access(ip, IEXEC))
		then goto bad;
	if((ip->i_mode & IFMT) != 0 ||
	   (ip->i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0)
	{	u.u_error = EACCES;
		goto bad;
	}

	/* pack up the arguments into the allocated buffer */
	cp = bp;
	na = 0;
	nc = 0;
	while( ap = fuword(u.u_arg[1]))
	{	na++;
		if (ap == -1)
			then goto bad;
		u.u_arg[1] =+ 2;
		for(;;)
		{	c = fubyte(ap++);
			if (c == -1)
				then goto bad;
			*cp++ = c;
			nc++;
			if(nc > 510) then
			{	u.u_error = E2BIG;
				goto bad;
			}
			if (c == 0)
				then break;
		}
	}
	if (nc&1) then
	{	*cp++ = 0;
		nc++;
	}

	/* read in first 8 bytes of file, to find out what's what */
	u.u_base = &u.u_arg[0];
	u.u_count = 8;
	u.u_offset[0] = 0;
	u.u_offset[1] = 0;
	u.u_segflg = 1;
	readi( ip );
	u.u_segflg = 0;
	if (u.u_error)
		then goto bad;
	sep = 0;
	if (u.u_arg[0] == 0407) then
	{	u.u_arg[2] =+ u.u_arg[1];
		u.u_arg[1] = 0;
	}
	else if ( u.u_arg[0] == 0411 ) then
	{	printf("unable to load separated load module\r\n");
		goto bad;
	}
	else if (u.u_arg[0] == 0410) then
	{	/* it is a pure text load module, not too hard */
	}
	else
	{	u.u_error = ENOEXEC;
		goto bad;
	}
/* ATTENTION: we are now committed to the new load module */
	destroyuser();
	u.u_tsize = ((u.u_arg[1]+63) >> 6) & 01777;
	u.u_dsize = ((u.u_arg[2]+u.u_arg[3]+63) >> 6) & 01777;
	u.u_ssize = SINCR;
	u.u_sep = sep;

	/* allocate enough segments to make up that image */
	if (!makeuser( u.u_tsize, u.u_dsize, u.u_ssize, u.u_sep ) )
	then	panic("exec");


	/* read in the text segment if there is one */
	u.u_base = 0;
	if (u.u_arg[1] == 0)
		goto readdata;
		else u.u_count = u.u_arg[1];
	u.u_offset[1] = 020;
	readi(ip);
	u.u_base = u.u_arg[1];
	u.u_base =+ 017777;
	u.u_base =& 0160000;

readdata:	/* read in data segment */
	u.u_offset[1] = 020 + u.u_arg[1];
	u.u_count = u.u_arg[2];
	readi(ip);

	/*	copy in his arguments 	*/
	cp = bp;
	ap = -nc - na*2 - 4;
	u.u_ar0[R6] = ap;
	suword(ap, na);
	c = -nc;
	while( na-- )
	{	suword( ap =+ 2, c );
		do
			subyte(c++, *cp);
		while( *cp++ );
	}
	suword( ap+2, -1);

	/* do setuid and setgid stuff if need be */
	if (ip->i_mode&ISUID)
		if(u.u_uid != 0)
			u.u_uid = ip->i_uid;
		
	if(ip->i_mode&ISGID)
		u.u_gid = ip->i_gid;

	/* clear signals and registers, then return */
	c = ip;
	for(ip = &u.u_precautions[0]; ip < &u.u_precautions[NSIG]; ip++)
		if ( (*ip & 1) == 0 ) then *ip = 0;
	u.u_ar0[R0] = 0;
	u.u_ar0[R1] = 0;
	u.u_ar0[R2] = 0;
	u.u_ar0[R3] = 0;
	u.u_ar0[R4] = 0;
	u.u_ar0[R5] = 0;
	u.u_ar0[R7] = 0;

	ip = c;
bad:
	iput(ip);
	return;
}

/*
 * exit system call:
 * pass back caller's r0
 */
rexit()
{

	u.u_arg[0] = u.u_ar0[R0] << 8;
	exit();
}

/*
 * close all files, then reinvoke init
 */
exit()
{
	register int *q, a;



/* FIX exit to really exit and send some status to someone */
	for(q = &u.u_ofile[3]; q < &u.u_ofile[NOFILE]; q++)
		if (a = *q) then
		{	*q = NULL;
			closef( a );
		}

	for(q = &u.u_precautions; q < &u.u_precautions[NSIG]; q++ )
		*q = NULL;

	userboot( /* bring in the shell */ );
}

/*
 * Wait system call.
 * Search for a terminated (zombie) child,
 * finally lay it to rest, and collect its status.
 * Look also for stopped (traced) children,
 * and pass back status from them.
 */
wait()
{
/* FIX wait to wait for the termination of a child */
	u.u_error = ECHILD;
}

/*
 * fork system call.
 */
fork()
{
	u.u_ar0[R0] = 0;
/* FIX fork to do something */
}

/*
 * memsize system call
 */
memsize()
{
/* FIX memsize to alter the user's map */
}
