///////////////////////////////////////////////////////////////////////////////
/			U C L A - Data Secure Unix			      /
/									      /
/		Machine Language Support for the C code			      /
/									      /
/		Based on a Bell Release 6 m45.s				      /
/	Changes designed and implemented by Mark Kampe			      /
///////////////////////////////////////////////////////////////////////////////

/	definitions of op codes not defined by the Unix assembler
mfpi	= 6500^tst
mtpi	= 6600^tst
mfpd	= 106500^tst
mtpd	= 106600^tst
rti	= 2
halt	= 0


.globl	start, _main, _u, _sysstack
start:	/ location 0 of the load module contains a "jmp start"
	/ initialize the system stack, clear the user block and enter _main
	mov	$_u+[usize*64.],sp	/ stack starts at top of user area
	mov	$_u,r0			/ then starting at bottom of user area
1:	clr	(r0)+			/ clear every word
	cmp	r0,sp			/ until the end of the user area
	blo	1b

	jsr	pc,_main		/ and enter the C code

/	when it returns (that means invoke the first user), enter user
/	mode at location zero
	mov	$170000,-(sp)		/ return ps in user mode
	clr	-(sp)			/ return pc of zero
	clr	-(sp)			/ start his stack at top of
	mtpd	sp			/ his memory space
	br	2f			/ and return (checking for interrupts)


.globl	trap, _retrap, fault, _trap
.globl	_RTI_ADR, _PC_ADR, _PS_ADR
/	trap is called with a "jsr pc,trap" that is placed in the
/	interrupt vector.  It makes the stack look nice and then
/	calls the C routine _trap.  When _trap returns, trap does an rti
/	unless the return is to user mode, in which case trap jumps through
/	the RTI in the communications segment (to check for missed interrupts)
/	The logical stack that _trap will see looks like:
/		return pc into trap
/		address of trap vector+4
/		saved user register 1
/		saved user register 0
/		saved user sp
/		space for trap pc	/ _trap will fill these in before
/		space for trap ps	/ returning (from info in comm. seg.
///////////////////////////////////////////////////////////////////////////////
trap:	tst	-(sp)		/ reserve space on stack for trap pc
	mfpd	sp		/ fetch the user sp
	mov	r0,-(sp)	/ save user r0 and user r1
	mov	r1,-(sp)	/ because csv won't
	mov	8.(sp),-(sp)	/ move the trap address up to top of stack
	jsr	pc,_trap	/ and call the C trap handler

/	assume that _trap has filled in the desired return pc and return ps
	tst	(sp)+		/ pop off the trap address
	mov	(sp)+,r1	/ restore user r1
	mov	(sp)+,r0	/ and user r0
	mtpd	sp		/ and the user sp
2:	bit	$100000,2(sp)	/ is trap ps in supervisor mode?
	beq	1f		/ if so...
	jmp	*_RTI_ADR	/ if not, check for missed kernel interrupt
1:	rti			/ else, return directly

_retrap: / if I missed a kernel interrupt (the rti at *_RTI_ADR was no-oped)
	/ I come here.  Fix up the stack and re enter the interrupt handler.
	mov	(sp)+,*_PC_ADR	/ put in desired return pc as trap pc
	mov	(sp),*_PS_ADR	/ and desired return ps as trap ps
	mov	$1000,(sp)	/ out of range vector (default is kernel int)
	br	trap		/ and say we just trapped

fault:	/ fault is for supervisor mode traps that might have been anticipated.
	/ if nofault was specified (meaning a trap was anticipated), go to
	/ the specified error location.  If not, take a normal trap
	tst	nofault		/ was nofault specified
	beq	trap		/ if not, this is an ordinary trap
	bit	*_PS_ADR,$100000 / was previous mode user
	bne	trap		/ if so, this is an ordinary trap
	mov	$070000,(sp)	/ return to supervisor mode (previous user)
	mov	nofault,-(sp)	/ and do the return to the specified error loc
	rti			/ and let error routine worry about it



/ Character list get/put/zap

.globl	_getc, _putc, _zapc
.globl	_cfreelist

_getc:
	mov	2(sp),r1
	mov	r2,-(sp)
	mov	2(r1),r2	/ first ptr
	beq	9f		/ empty
	movb	(r2)+,r0	/ character
	bic	$!377,r0
	mov	r2,2(r1)
	dec	(r1)+		/ count
	bne	1f
	clr	(r1)+
	clr	(r1)+		/ last block
	br	2f
1:
	bit	$7,r2
	bne	3f
	mov	-10(r2),(r1)	/ next block
	add	$2,(r1)
2:
	dec	r2
	bic	$7,r2
	mov	_cfreelist,(r2)
	mov	r2,_cfreelist
3:
	mov	(sp)+,r2
	rts	pc
9:
	clr	4(r1)
	mov	$-1,r0
	mov	(sp)+,r2
	rts	pc

_putc:
	mov	2(sp),r0
	mov	4(sp),r1
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	4(r1),r2	/ last ptr
	bne	1f
	mov	_cfreelist,r2
	beq	9f
	mov	(r2),_cfreelist
	clr	(r2)+
	mov	r2,2(r1)	/ first ptr
	br	2f
1:
	bit	$7,r2
	bne	2f
	mov	_cfreelist,r3
	beq	9f
	mov	(r3),_cfreelist
	mov	r3,-10(r2)
	mov	r3,r2
	clr	(r2)+
2:
	movb	r0,(r2)+
	mov	r2,4(r1)
	inc	(r1)		/ count
	clr	r0
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc
9:
	mov	pc,r0
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc

_zapc:	/ remove last character from a queue (unless it is a delimiter)
	mov	2(sp),r1		/ get the pointer to the qcb
	mov	r2,-(sp)		/ and save some other
	mov	r3,-(sp)		/ scratch registers
	mov	$177777,r0		/ assume it is going to fail
	mov	4(r1),r2		/ get the pointer to the last block
	beq	9f			/ if none, can't zap it
	cmpb	-(r2),$377		/ is it a delimiter
	beq	9f			/ if so, don't zap it

	movb	(r2),r0			/ get the character to be removed
	bic	$!377,r0		/ leave only the character
	mov	r2,4(r1)		/ update the last character pointer
	sub	$2,r2			/ subtract two bytes from pointer
	dec	(r1)			/ decrement the queue character count
	beq	1f			/ if zero, release this block
	bit	$7,r2			/ and see if we backed off end of block
	beq	1f			/ if so, we have to release the block
9:	mov	(sp)+,r3		/ restore the registers
	mov	(sp)+,r2		/ that I dirtied
	rts	pc			/ and return to the caller

1:	bic	$7,r2			/ get base address for empty block
	mov	_cfreelist,(r2)		/ link the newly emptied block into
	mov	r2,_cfreelist		/ the head of the free element list
	tst	(r1)+			/ check the character count
	bne	2f			/ if count is positive, more work to do
	clr	(r1)+			/ if it is zero, just clobber the
	clr	(r1)			/ first and last pointers and
	br	9b			/ we are done.

/ we have to search for the last block in the queue and fix up some pointers
2:	mov	(r1)+,r3		/ get address of first block in queue
	bic	$7,r3			/ truncate address to base of block
3:	cmp	(r3),r2			/ does it point forward to empty block
	beq	4f			/ if so, we found pointers to fix
	mov	(r3),r3			/ else follow the forward link
	br	3b			/ and try again
4:	clr	(r3)			/ say it points forward to nothing
	add	$10,r3			/ addr past last char in that block
	mov	r3,(r1)			/ and say thats the last char in queue
	br	9b			/ cleanup and return



.globl	_fword
.globl	_fubyte, _subyte
.globl	_fuword, _suword
.globl	_fuibyte, _suibyte
.globl	_fuiword, _suiword
_fuibyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,giword
	br	2f

_fubyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,gword

2:
	cmp	r1,2(sp)
	beq	1f
	swab	r0
1:
	bic	$!377,r0
	rts	pc

_suibyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,giword
	mov	r0,-(sp)
	cmp	r1,4(sp)
	beq	1f
	movb	6(sp),1(sp)
	br	2f
1:
	movb	6(sp),(sp)
2:
	mov	(sp)+,r0
	jsr	pc,piword
	clr	r0
	rts	pc

_subyte:
	mov	2(sp),r1
	bic	$1,r1
	jsr	pc,gword
	mov	r0,-(sp)
	cmp	r1,4(sp)
	beq	1f
	movb	6(sp),1(sp)
	br	2f
1:
	movb	6(sp),(sp)
2:
	mov	(sp)+,r0
	jsr	pc,pword
	clr	r0
	rts	pc

_fuiword:
	mov	2(sp),r1
fuiword:
	jsr	pc,giword
	rts	pc

_fuword:
	mov	2(sp),r1
fuword:
	jsr	pc,gword
	rts	pc

giword:
	mov	nofault,-(sp)
	mov	$err,nofault
	mfpi	(r1)
	mov	(sp)+,r0
	br	1f

gword:
	mov	nofault,-(sp)
	mov	$err,nofault
	mfpd	(r1)
	mov	(sp)+,r0
	br	1f

_suiword:
	mov	2(sp),r1
	mov	4(sp),r0
suiword:
	jsr	pc,piword
	rts	pc

_suword:
	mov	2(sp),r1
	mov	4(sp),r0
suword:
	jsr	pc,pword
	rts	pc

piword:
	mov	nofault,-(sp)
	mov	$err1,nofault
	mov	r0,-(sp)
	mtpi	(r1)
	br	1f

pword:
	mov	nofault,-(sp)
	mov	$err1,nofault
	mov	r0,-(sp)
	mtpd	(r1)
1:
	mov	(sp)+,nofault
	rts	pc

err1:	tst	(sp)+	/ kernel backed up the stack for me, pop off garbage
err:
	mov	(sp)+,nofault
	tst	(sp)+
	mov	$-1,r0
	rts	pc

_fword:	/ supervisor uses this to fetch words from its own space if it
	/ isn't sure of the validity of the address
	mov	2(sp),r1		/ get the address in question
	tst	-(sp)			/ leave an extra word for err to pop
	mov	nofault,-(sp)		/ save the previous nofault
	mov	$err,nofault		/ use err should this fail
	mov	(r1),r0			/ ihopeitdoesnthurt
	mov	(sp)+,nofault		/ phweew!
	tst	(sp)+			/ got away with it
	rts	pc			/ return the value


.globl	_copyin, _copyout
.globl	_copyiin, _copyiout
_copyiin:
	jsr	pc,copsu
1:
	mfpi	(r0)+
	mov	(sp)+,(r1)+
	sob	r2,1b
	br	2f

_copyin:
	jsr	pc,copsu
1:
	mfpd	(r0)+
	mov	(sp)+,(r1)+
	sob	r2,1b
	br	2f

_copyiout:
	jsr	pc,copsu
	mov	$3f,nofault	/ special recovery for mt serries instructions
1:
	mov	(r0)+,-(sp)
	mtpi	(r1)+
	sob	r2,1b
	br	2f

_copyout:
	jsr	pc,copsu
	mov	$3f,nofault	/ special recovery for mf serries instructions
1:
	mov	(r0)+,-(sp)
	mtpd	(r1)+
	sob	r2,1b
2:
	mov	(sp)+,nofault
	mov	(sp)+,r2
	clr	r0
	rts	pc

	tst	(sp)+	/ pop off the word of garbage
	br	2b	/ and then treat it like a normal trap

copsu:
	mov	(sp)+,r0
	mov	r2,-(sp)
	mov	nofault,-(sp)
	mov	r0,-(sp)
	mov	10(sp),r0
	mov	12(sp),r1
	mov	14(sp),r2
	asr	r2
	mov	$1f,nofault
	rts	pc

3:	/ mt serries instructions trap slightly differently under the
	/ kernel than on a bare machine.  namely, the kernel backs up
	/ any affected regester (eg r6).  The result is that the source
	/ word is still on the stack (and should be popped off as trash)
	tst	(sp)+
1:
	mov	(sp)+,nofault
	mov	(sp)+,r2
	mov	$-1,r0
	rts	pc

.globl	_dpadd
_dpadd:
	mov	2(sp),r0
	add	4(sp),2(r0)
	adc	(r0)
	rts	pc

.globl	_dpsub
_dpsub:
	mov	2(sp),r0
	sub	4(sp),2(r0)
	sbc	(r0)
	rts	pc

.globl	_dpcmp
_dpcmp:
	mov	2(sp),r0
	mov	4(sp),r1
	sub	6(sp),r0
	sub	8(sp),r1
	sbc	r0
	bge	1f
	cmp	r0,$-1
	bne	2f
	cmp	r1,$-512.
	bhi	3f
2:
	mov	$-512.,r0
	rts	pc
1:
	bne	2f
	cmp	r1,$512.
	blo	3f
2:
	mov	$512.,r1
3:
	mov	r1,r0
	rts	pc

.globl	_ldiv
_ldiv:
	clr	r0
	mov	2(sp),r1
	div	4(sp),r0
	rts	pc

.globl	_lrem
_lrem:
	clr	r0
	mov	2(sp),r1
	div	4(sp),r0
	mov	r1,r0
	rts	pc

.globl	_lshift
_lshift:
	mov	2(sp),r1
	mov	(r1)+,r0
	mov	(r1),r1
	ashc	4(sp),r0
	mov	r1,r0
	rts	pc

.globl	csv
csv:
	mov	r5,r0
	mov	sp,r5
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	jsr	pc,(r0)

.globl cret
cret:
	mov	r5,r1
	mov	-(r1),r4
	mov	-(r1),r3
	mov	-(r1),r2
	mov	r5,sp
	mov	(sp)+,r5
	rts	pc


.globl	_swab
_swab:
	mov	2(sp),r0
	swab	r0
	rts	pc

usize	= 16.
.bss
.globl	nofault
nofault:.=.+2
.globl _etext, _edata, _end
