#
/*****************************************************************
 **								**
 **		   U C L A  Data Secure Unix			**
 **								**
 **			Copyright 1977				**
 **								**
 **    Mark Kampe, Charles Kline, Gerald Popek, Evelyn Walton	**
 **								**
 *****************************************************************/
#include "../conf.h"
#include "../../shared/constants.h"
#include "../../shared/fscom.h"
/*
 *	device configuration for UCLA-SECURITY Data Secure Unix
 */


/*
 *	character device switch table
 *		Each entry is a pointer to five routines (respectively)
 *		 open, close, read, write, special function
 *		The index of each entry is its Unix major device number
 */
struct cdevsw cdevsw[]
{
	&ttyopen  , &ttyclose , &ttread   , &ttwrite  , &ttystty  ,
	0         , 0         , 0         , 0         , 0
};


/*
 *	interrupt vectoring table
 *		Each entry is a pointr to two routines (respectively)
 *			input interrupt handler and output interrupt handler
 *		The index of each entry is the generic device class which
 *		those routines handle.  The generic device classes are defined
 *		in fsproc.h
 */
struct	intrtab intrtab[]
{	&spurious,	&spurious,	/* there is no generic device zero */
	&ttyiint,	&spurious,	/* device type 1 - input teletypes */
	&spurious,	&ttyoint,	/* device type 2 - output teletypes */
	0,		0
};



int	rootdev	{ 0 };			/* disk number of root device */
