cgjsimeq
	subroutine simeq (a,b,n,kerr,idim)
c     simeq
c:     this subroutine solves a system of linear equations
c:     ax=b by the method of pivotal condensation.it is used
c:     for dense matrices of coefficients.
c:     calling arguments:
c:     a: the name of an n by n matrix of coefficients of the equations
c:             which is destroyed during computation.
c:     b: the name of an array containing the n constants.
c:     n: the order of the system
c:     kerr: indicator returned by the subroutine which is
c:             one if system is singular and zero otherwise.
c:           read a column by column.
c:
	dimension a(idim,idim),b(idim),l(50),m(50)
	eps=1e-6
	epsqr=eps*eps
	kerr=0
c:     clear out permutation vectors
	do 3 i=1,n
	m(i)=0
3	l(i)=0
c:     loop for n pivot points
	do 14 kp=1,n
	p=0.
	psqr=0.
	do 7 i=1,n
	do 7 j=1,n
	if(m(i))7,4,7
4	if(l(j))7,5,7
5	t=a(i,j)
	tsqr=t*t
	if (tsqr-psqr)7,7,6
6	p=t
	psqr=tsqr
	kr=i
	kc=j
7	continue
	if (psqr-epsqr)17,17,8
8	m(kr)=kc
	l(kc)=1
c:     divide key row by pivot
	do 10 j=1,n
	if(l(j))10,9,10
9	a(kr,j)=a(kr,j)/p
10	continue
	bkr=b(kr)/p
	b(kr)=bkr
c:     subtract multiple of key row from other rows
	do 14 i=1,n
	if (i-kr)11,14,11
11	r=a(i,kc)
	do 13 j=1,n
	if (l(j)) 13,12,13
12	a(i,j)=a(i,j)-r*a(kr,j)
13	continue
	b(i)=b(i)-r*bkr
14	continue
c:     reorder results
	do 15 i=1,n
	ip=m(i)
15	a(ip,1)=b(i)
	do 16 i=1,n
16	b(i)=a(i,1)
	return
c:     error action
17	kerr=1
	return
	end
