	doubleprecision function scale(nn,pt,eta,infin,smalno,base)

c returns a scale factor to multiply the coefficients of the
c polynomial. the scaling is done to avoid overflow and to avoid
c undetected underflow interfering with the convergence
c criterion.  the factor is a power of the base.
c pt - modulus of the coefficients of p
c eta, infin, smalno, base - constants describing the
c floating point arithmetic
	doubleprecision pt(nn),eta,infin,smalno,base,hi,lo,max,min,x,sc

c find largest and smallest moduli of coefficients

	hi = dsqrt(infin)
	lo = smalno/eta
	max = 0.0d0
	min = infin
	do 10 i = 1,nn
		x = dabs(pt(i))
		if (x .gt. max) max = x
		if (x .ne. 0.0d0 .and. x .lt. min) min = x
10	continue

c scale only if there are very large or very small coefficients

	scale = 1.0d0
	if (min.ge.lo .and. max.le.hi) return
	x = lo/min
	if (x .gt. 1.0d0) goto 20
		sc = 1.0d0/(dsqrt(max)*dsqrt(min))
		goto 30
20	sc = x
	if (infin/sc .gt. max) sc = 1.0d0
30	l = dlog(sc)/dlog(base) + .5d0
	scale = base**l
	return
	end
