	subroutine fxshft(l2,z,conv)

c computes l2 fixed-shift polynimials and tests for convergence
c initiates a variable-shift iteration and returns with
c the approximate zero if successful.
c l2 - limit of fixed shift steps
c z - approximate zero if conv is true
c conv - logical indicating convergence of stage 3 iteration

	common /global/ p, h, qp, qh, shr, shi, s, t, pv, are,
&		mre, eta, infin, nn
	doublecomplex s, t, pv, p(15), h(15), qp(15), qh(15)
	doubleprecision are, mre, eta, infin, shr(15), shi(15)

	doublecomplex z, ot, svs
	logical conv, test, pasd, bool

	n = nn-1

c evaluate p at s

	call polyev(nn, s, p, qp, pv)
	test = .true.
	pasd = .false.

c calculate first t = -p(s)/h(s)

	call calct(bool)

c main loop for one second stage step

	do 50 j = 1, l2
		ot = t

c compute next h polynomial and new t

		call nexth(bool)
		call calct(bool)
		z = s+t

c test for convergence unless stage 3 has failed once or this
c is the last h polynomial

		if (bool .or. .not. test .or. j .eq. l2) goto 50
		if (dcabs(t-ot) .ge. .5d0*dcabs(z)) goto 40
			if (.not. pasd) goto 30
				do 10 i = 1,n
					shr(i) = dreal(h(i))
					shi(i) = dimag(h(i))
10				continue
				svs = s
				call vrshft(10, z, conv)
				if (conv) return

c the iteration failed to converge.
c turn off testing and restore h, s, pv, and t.

				test = .false.
				do 20 i = 1,n
					h(i) = dcmplx(shr(i),shi(i))
20				continue
				s = svs
				call polyev(nn,s,p,qp,pv)
				call calct(bool)
				goto 50
30			pasd = .true.
			goto 50
40		pasd = .false.
50	continue

c attempt an iteration with final h polynomial from second stage.

	call vrshft(10,z,conv)
	return
	end
