/*
 * Remote Laboratory Instrumentation Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2009 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

extern double commanalyzer_raw_trace_data[1024];

unsigned long commanalyzerTraceLength (const char * commanalyzerType);
int commanalyzer_set_date(struct tm * datetime, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_time(struct tm * datetime, const char * commanalyzerType, int gpibDevice);
int commanalyzer_switch_to_spectrum_analyzer_mode (const char * commanalyzerType, int gpibDevice);
int commanalyzer_lock_screen (const char * commanalyzerType, int gpibDevice);

int commanalyzer_get_spectrum_analyzer_trace (const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_display_brightness(float percent, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_center_frequency(float desired_frequency, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_frequency_span(float desired_frequency, const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_mode_tracking (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_mode_fixed (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_rf_input_dedicated (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_rf_input_muxed (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_output_dedicated (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_output_muxed (const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_input_attenuation(float desired_attenuation, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_scale(float desired_scale, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_input_attenuator_mode_auto( const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_input_attenuator_mode_fixed( const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_generator_power(float desired_power, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_generator_frequency(float desired_frequency, const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_sweep_ascending (const char * commanalyzerType, int gpibDevice);
int commanalyzer_spectrum_analyzer_set_generator_sweep_descending (const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_trace_averaging(float desired_avg_samples, const char * commanalyzerType, int gpibDevice);
int commanalyzer_set_spectrum_analyzer_reference_power_level(float desired_reflevel, const char * commanalyzerType, int gpibDevice);
int commanalyzer_get_spectrum_analyzer_number_of_vertical_divisions( const char * commanalyzerType, int gpibDevice);
int commanalyzer_get_spectrum_analyzer_number_of_horizontal_divisions( const char * commanalyzerType, int gpibDevice);

double commanalyzer_get_spectrum_analyzer_reference_power_level (double * retval, const char * commanalyzerType, int gpibDevice);
double commanalyzer_get_spectrum_analyzer_scale (double * retval, const char * commanalyzerType, int gpibDevice);
double commanalyzer_get_spectrum_analyzer_center_frequency (double * retval, const char * commanalyzerType, int gpibDevice);
double commanalyzer_get_spectrum_analyzer_span (double * retval, const char * commanalyzerType, int gpibDevice);