/*
 * Remote Laboratory FPGA Server
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2013 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

#include <tqsocket.h>
#include <tqserversocket.h>
#include <tqapplication.h>
#include <tqvbox.h>
#include <tqtextview.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqtextstream.h>

#include <ksimpleconfig.h>

#include <tdekrbserversocket.h>

#include <tqtrla.h>

#define MAGIC_NUMBER 1
#define PROTOCOL_VERSION 1

class FPGASocket : public TDEKerberosServerSocket
{
	Q_OBJECT

	public:
		FPGASocket(int sock, TQObject *parent=0, const char *name=0);
		~FPGASocket();

	public:
		void close();
		void initiateKerberosHandshake();
		int enterCommandLoop();

	private slots:
		void finishKerberosHandshake();
		void connectionClosedHandler();
		int setupSerial();
		int setupGPMC();
		void commandLoop();
	
	private:
		int line;
		int m_criticalSection;
		int m_pollInterval;
		bool enableDebug;
		TQString m_remoteHost;
		TQString m_interfaceType;
		bool m_stateTXRequested;
		bool m_stateImageRXRequested;
		int m_stateImageRXCounter;
		bool m_stateImageTXRequested;
		int m_fd_tty;

		TQTimer* m_kerberosInitTimer;
		TQTimer* m_loopTimer;

		KSimpleConfig* m_config;

		friend class FPGAServer;
};

class FPGAServer : public TQServerSocket
{
	Q_OBJECT

	public:
		FPGAServer(TQObject* parent=0, int port=0, KSimpleConfig* config=0);
		~FPGAServer();
	
		void newConnection(int socket);

	private slots:
		void remoteConnectionClosed();
	
	signals:
		void newConnect(FPGASocket*);

	private:
		KSimpleConfig* m_config;
		int m_numberOfConnections;

		friend class FPGASocket;

};