/***************************************************************************
 *   Copyright (C) 2012-2019 by Timothy Pearson                            *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TQTRLA_H
#define TQTRLA_H

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqtimer.h>
#include <tqdatetime.h>

#include <tdeaction.h>

#include <tdeparts/part.h>

#include <tdekrbclientsocket.h>

// =============================================================================

typedef TQValueList<float> TQFloatList;
typedef TQValueList<double> TQDoubleList;
typedef TQValueList<TQ_INT32> TQInt32List;
typedef TQValueList<TQ_INT16> TQInt16List;

// =============================================================================

class KMdiMainFrm;

namespace KParts
{
	class RemoteInstrumentPartPrivate;

	class TDEPARTS_EXPORT RemoteInstrumentPart : public Part
	{
		Q_OBJECT

		public:
			RemoteInstrumentPart(TQObject *parent = 0, const char *name = 0);
			virtual ~RemoteInstrumentPart();
	
		public slots:
			virtual bool openURL( const KURL &url );
	
		public:
			KURL url() const { return m_url; }
			virtual bool closeURL();
			virtual TQPtrList<TDEAction> menuActionList();

		protected:
			TQStringList textForServerError(TQString shortError);
			TQ_ULONG maximumSocketDataChunkSize();
			void setUsingFixedSize(bool fixed);

		public:
			int connectToServer(TQString server);
			void disconnectFromServer();
			void setMDIMainForm(KMdiMainFrm* form);
			KMdiMainFrm* mdiMainForm();

		private:
			int getNewTicket();

		private slots:
			void finishConnectingToServer();
			virtual void connectionFinishedCallback();
			virtual void disconnectFromServerCallback();
			virtual void connectionStatusChangedCallback();

		protected slots:
			void close();
			void resize(TQSize size);
			void setStatusMessage(const TQString& message);

		signals:
			void statusMessageSet(const TQString&);
			void usingFixedSizeChanged(bool);
			void resizeToHintRequested();
	
		protected:
			KURL m_url;
			TQString m_clientLibraryName;

		protected:
			TDEKerberosClientSocket* m_socket;
			TQTimer* m_connectionTimer;
			bool connToServerConnecting;
			int connToServerState;
			TQTimer *connToServerTimeoutTimer;
			bool m_fixedSize;
			KMdiMainFrm* m_mdiMainForm;
			TQString m_hostName;
	
		private:
			RemoteInstrumentPartPrivate *d;
	};
}

// =============================================================================

typedef TQMemArray<float> TQFloatArray;

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const TQFloatArray &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, TQFloatArray &);
#endif

// =============================================================================

typedef TQMemArray<double> TQDoubleArray;

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const TQDoubleArray &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, TQDoubleArray &);
#endif

// =============================================================================

class ServiceType
{
	public:
		TQ_UINT32 type;
		TQString name;
		TQString description;
		TQString clientLibrary;
		int version;
		bool singleInstance;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const ServiceType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, ServiceType &);
#endif

typedef TQValueList<ServiceType> ServiceList;

Q_EXPORT bool operator==(const ServiceType &s1, const ServiceType &s2);

// =============================================================================

class StationType
{
	public:
		TQ_UINT32 id;
		TQ_UINT32 type;
		ServiceList services;
		TQString name;
		TQString description;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const StationType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, StationType &);
#endif

class StationList : public TQValueList<StationType>
{
	public:
		StationList();
		virtual ~StationList();

	public:
		StationList::iterator findByID(TQ_UINT32 id);
};

// =============================================================================

class SensorType
{
	public:
		TQ_UINT32 index;
		TQString name;
		TQString description;
		TQString units;
		double min;
		double max;
		double mininterval;
		double nominalinterval;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const SensorType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, SensorType &);
#endif

typedef TQValueList<SensorType> SensorList;

// =============================================================================

class TerminalServiceStatusType
{
	public:
		TQ_UINT32 protocolVersion;
		TQ_INT32 sessionID;
		TQString username;
		TQString serverName;
		TQ_INT32 serverPID;
		TQ_INT32 wmPID;
		TQ_INT32 state;
		TQ_INT32 display;
		TQDateTime loginStamp;
		TQDateTime activityStamp;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const TerminalServiceStatusType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, TerminalServiceStatusType &);
#endif

typedef TQValueList<TerminalServiceStatusType> TerminalServiceStatusList;

// =============================================================================

class WorkspaceServiceStatusType
{
	public:
		TQ_UINT32 protocolVersion;
		TQ_INT32 sessionID;
		TQ_INT32 stationID;
		TQString username;
		TQString realmname;
		TQ_INT32 serverID;
		TQ_INT32 serviceID;
		TQString stationName;
		TQDateTime loginStamp;
		TQDateTime terminateStamp;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const WorkspaceServiceStatusType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, WorkspaceServiceStatusType &);
#endif

typedef TQValueList<WorkspaceServiceStatusType> WorkspaceServiceStatusList;

// =============================================================================

class TerminalServiceAuthGroupType
{
	public:
		TQ_UINT32 protocolVersion;
		TQString groupName;
		TQStringList allowedServerNames;
		TQ_UINT32 maximumActiveSessionCount;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const TerminalServiceAuthGroupType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, TerminalServiceAuthGroupType &);
#endif

class TerminalServiceAuthGroupList : public TQValueList<TerminalServiceAuthGroupType>
{
	public:
		TerminalServiceAuthGroupList();
		virtual ~TerminalServiceAuthGroupList();

	public:
		TerminalServiceAuthGroupList::iterator findByName(TQString name);
};

// =============================================================================

class WorkspaceServiceAuthGroupType
{
	public:
		TQ_UINT32 protocolVersion;
		TQString groupName;
		TQInt32List allowedStationIDs;
};

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<(TQDataStream &, const WorkspaceServiceAuthGroupType &);
Q_EXPORT TQDataStream &operator>>(TQDataStream &, WorkspaceServiceAuthGroupType &);
#endif

class WorkspaceServiceAuthGroupList : public TQValueList<WorkspaceServiceAuthGroupType>
{
	public:
		WorkspaceServiceAuthGroupList();
		virtual ~WorkspaceServiceAuthGroupList();

	public:
		WorkspaceServiceAuthGroupList::iterator findByName(TQString name);
};

// =============================================================================

#endif // TQTRLA_H
