/*
 * Remote Laboratory FPGA Server GPMC Interface (Beaglebone Black)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * (c) 2012-2019 Timothy Pearson
 * Raptor Engineering
 * http://www.raptorengineeringinc.com
 */

int setup_gpmc_bbb();

void write_gpmc(unsigned int register_offset, unsigned char data);
unsigned char read_gpmc(unsigned int register_offset);

void write_gpmc_uint16_t(unsigned int register_offset, uint16_t data);
uint16_t read_gpmc_uint16_t(unsigned int register_offset);

void write_gpmc_uint64_t(unsigned int register_offset, uint64_t data);
uint64_t read_gpmc_uint64_t(unsigned int register_offset);

void memcpy_from_gpmc(char* destination, unsigned int register_offset, unsigned int length);
void memcpy_to_gpmc(char* source, unsigned int register_offset, unsigned int length);