/*
    ircaccount.h - IRC Account

    Copyright (c) 2002      by Nick Betcher <nbetcher@kde.org>
    Copyright (c) 2003      by Jason Keirstead <jason@keirstead.org>

    Kopete    (c) 2002      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef IRCACCOUNT_H
#define IRCACCOUNT_H

#include "ircprotocol.h"

#include "kircengine.h"

#include "kopetepasswordedaccount.h"

#include <kdialogbase.h>

#include <tqstring.h>
#include <tqstringlist.h>

class ChannelListDialog;

class IRCContact;
class IRCChannelContact;
class IRCContactManager;
class IRCServerContact;
class IRCProtocol;
class IRCUserContact;

namespace Kopete
{
class AwayAction;
class Contact;
class Message;
class ChatSession;
class MetaContact;
}

class TDEAction;
class TDEActionMenu;

struct IRCHost
{
	TQString host;
	uint port;
	TQString password;
	bool ssl;
};

struct IRCNetwork
{
	TQString name;
	TQString description;
	TQValueList<IRCHost*> hosts;
};

class IRCAccount
	: public Kopete::PasswordedAccount
{
	friend class IRCEditAccountWidget;
	friend class IRCProtocolHandler;

	TQ_OBJECT
  

public:
	static const TQString CONFIG_CODECMIB;
	static const TQString CONFIG_NETWORKNAME;
	static const TQString CONFIG_NICKNAME;
	static const TQString CONFIG_USERNAME;
	static const TQString CONFIG_REALNAME;

	enum MessageType
	{
		ConnectReply = 1,
		InfoReply = 2,
		NoticeReply = 4,
		ErrorReply = 8,
		UnknownReply = 16,
		Default = 32
	};

	enum MessageDestination
	{
		ActiveWindow = 1,
		ServerWindow = 2,
		AnonymousWindow = 3,
		KNotify = 4,
		Ignore = 5
	};

	IRCAccount(IRCProtocol *p, const TQString &accountid, const TQString &autoConnect = TQString(),
			const TQString& networkName = TQString(), const TQString &nickName = TQString());
	virtual ~IRCAccount();

	void setNickName( const TQString & );

	void setAutoShowServerWindow( bool show );

	void setAltNick( const TQString & );
	const TQString altNick() const;

	void setUserName( const TQString & );
	const TQString userName() const;

	void setRealName( const TQString & );
	const TQString realName() const;

	const TQStringList connectCommands() const;

	void setConnectCommands( const TQStringList & ) const;

	void setDefaultPart( const TQString & );

	void setNetwork( const TQString & );

	void setDefaultQuit( const TQString & );

	void setCodec( TQTextCodec *codec );

	void setMessageDestinations( int serverNotices, int serverMessages,
		int informationReplies, int errorMessages );

	TQTextCodec *codec() const;

	const TQString defaultPart() const;

	const TQString defaultQuit() const;

	const TQString networkName() const;

	TQMap< TQString, TQString > customCtcp() const;

	void setCustomCtcpReplies( const TQMap< TQString, TQString > &replys ) const;

	const TQMap<TQString, TQString> customCtcpReplies() const;

	void setCurrentCommandSource( Kopete::ChatSession *session );

	Kopete::ChatSession *currentCommandSource();

	IRCContact *getContact(const TQString &name, Kopete::MetaContact *metac=0);
	IRCContact *getContact(KIRC::EntityPtr entity, Kopete::MetaContact *metac=0);

public slots:

	virtual TDEActionMenu *actionMenu();

	virtual void setAway( bool isAway, const TQString &awayMessage = TQString() );

	virtual bool isConnected();

	/** Reimplemented from Kopete::Account */
	void setOnlineStatus( const Kopete::OnlineStatus& status , const TQString &reason = TQString());

	// Returns the KIRC engine instance
	KIRC::Engine *engine() const { return m_engine; }

	// Returns the IRCProtocol instance for contacts
	IRCProtocol *protocol() const { return m_protocol; }

	IRCContactManager *contactManager() const { return m_contactManager; }

	// Returns the Kopete::Contact of the user
	IRCUserContact *mySelf() const;

	// Returns the Kopete::Contact of the server of the user
	IRCServerContact *myServer() const;

	void successfullyChangedNick(const TQString &, const TQString &);

	virtual void connectWithPassword( const TQString & );
	virtual void disconnect();

	void quit( const TQString &quitMessage = TQString() );

	void listChannels();

	void appendMessage( const TQString &message, MessageType type = Default );

protected:
	virtual bool createContact( const TQString &contactId, Kopete::MetaContact *parentContact ) ;

private slots:
	void engineStatusChanged(KIRC::Engine::Status newStatus);

	void destroyed(IRCContact *contact);

	void slotFailedServerPassword();
	void slotGoAway( const TQString &reason );
	void slotJoinNamedChannel( const TQString &channel );
	void slotJoinChannel();
	void slotShowServerWindow();
	void slotNickInUse( const TQString &nick );
	void slotNickInUseAlert( const TQString &nick );
	void slotServerBusy();
	void slotNoSuchNickname( const TQString &nick );
	void slotSearchChannels();
	void slotNewCtcpReply(const TQString &type, const TQString &target, const TQString &messageReceived);
	void slotJoinedUnknownChannel( const TQString &channel, const TQString &nick );
	void slotPerformOnConnectCommands();

private:
	Kopete::ChatSession *m_manager;
	TQString mNickName;
	Kopete::AwayAction *mAwayAction;
	bool triedAltNick;
	bool autoShowServerWindow;
	TQString autoConnect;

	KIRC::Engine *m_engine;
	IRCNetwork *m_network;
	uint currentHost;
	TQTextCodec *mCodec;

	MessageDestination m_serverNotices;
	MessageDestination m_serverMessages;
	MessageDestination m_informationReplies;
	MessageDestination m_errorMessages;

	ChannelListDialog *m_channelList;

	TQValueList<IRCContact *> m_contacts;
	IRCContactManager *m_contactManager;
	IRCServerContact *m_myServer;

	TQMap< TQString, TQString > m_customCtcp;
	Kopete::ChatSession *commandSource;

	TDEAction *m_joinChannelAction;
	TDEAction *m_searchChannelAction;
};

#endif
