//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfselectactivetarget.h"

// TQt includes
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqfile.h>
#include <tqdir.h>
#include <tqdom.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqlistview.h>
#include <tqradiobutton.h>
#include <tqpushbutton.h>
#include <tqlineedit.h>
#include <tqtextedit.h>
#include <tqlabel.h>
#include <tqbuttongroup.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>

// KDE includes
#include <tdelocale.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <tdelocale.h>
#include <tdeio/netaccess.h>
#include <tdeio/job.h>
#include <ktrader.h>
#include <klibloader.h>
#include <tdelistview.h>
#include <tdelistbox.h>
#include <knuminput.h>
#include <kpushbutton.h>
#include <tdemessagebox.h>
#include <tdetempfile.h>

// Project includes
#include "kmflistviewitem.h"
#include "../version.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfdoc.h"
#include "../core/kmftarget.h"


//##### static stuff
namespace KMF {
KMFTarget * KMFSelectActiveTarget::selectTarget( KMFNetwork* network, const TQString& msg ) {
	kdDebug() << "KMFTarget * KMFSelectActiveTarget::selectTarget( KMFNetwork* network, const TQString& " << msg << " )" << endl;
	TQPtrList<KMFTarget> *list = new TQPtrList<KMFTarget>;
	network->netzone()->getAllTargets( network->netzone(), list );
	if ( list->count() == 1 ) {
		return network->currentTarget();
	}
	
	
	
	KMFSelectActiveTarget *selTG = new KMFSelectActiveTarget( 0, "KMFSelectActiveTarget",
	   TQWidget::WType_Dialog | TQWidget::WShowModal 
	 );
	selTG->setMessage( msg  );
	selTG->loadNetwork( network );
	selTG->exec();
	KMFTarget *tg = selTG->selectedTarget();
	if ( tg ) {
		kdDebug() << "Selected Target: " << tg->guiName() << endl;
		return tg;
	}
	return 0;

}

//##### end static

KMFSelectActiveTarget::KMFSelectActiveTarget ( TQWidget* parent, const char* name, bool modal, WFlags fl )
		: KMyFirewallSelectActiveTarget ( parent,name,modal,fl )
{
	m_cmd_ok->setEnabled( false );	
	
	connect( m_lv_zones, TQ_SIGNAL( pressed( TQListViewItem* ) ) ,
		 this, TQ_SLOT( slotNewItemSelected( TQListViewItem* ) ) );
	
	connect( m_lv_zones, TQ_SIGNAL( doubleClicked ( TQListViewItem *, const TQPoint &, int ) ) ,
		 this, TQ_SLOT( slotNewItemDBLClicked( TQListViewItem*, const TQPoint &, int  ) ) );	 
	
	connect( m_cmd_cancel, TQ_SIGNAL( clicked() ) ,
		 this, TQ_SLOT( slotCancel() ) );	 
	connect( m_cmd_ok, TQ_SIGNAL( clicked() ) ,
		 this, TQ_SLOT( slotOk() ) );
		 
	adjustSize();
}

KMFSelectActiveTarget::~KMFSelectActiveTarget()
{}

/*$SPECIALIZATION$*/


void KMFSelectActiveTarget::loadNetwork( KMFNetwork* net ) {
	kdDebug() << "KMFSelectActiveTarget::loadNetwork( KMFNetwork* )" << endl;
	if ( ! net ) {
		return;
	}
	m_network = net;
	m_lv_zones->clear();
	KMFListViewItem *it = new KMFListViewItem( m_lv_zones, 0, m_network->netzone() );
	it->setupZoneView();
}
void KMFSelectActiveTarget::setMessage( const TQString& msg ) {
	kdDebug() << "KMFSelectActiveTarget::setMessage( const TQString& )" << endl;
	m_lbl_message->setText( msg );
}
void KMFSelectActiveTarget::slotTargetSelected() {
	kdDebug() << "KMFSelectActiveTarget::slotTargetSelected()" << endl;
	
	
}

void KMFSelectActiveTarget::slotNewItemDBLClicked( TQListViewItem* item, const TQPoint &, int  ) {
	slotNewItemSelected( item );
	if ( m_target ) {
		slotOk();
	}
}

void KMFSelectActiveTarget::slotNewItemSelected( TQListViewItem* item ) {
	kdDebug() << "void KMFMyNetworkWidget::slotNewItemSelected( TQListViewItem* item )" << endl;
	if ( ! item )
		return ;
	m_target = 0;
	
	m_lv_zones->blockSignals( true );
	m_lv_zones->clearSelection();
	m_lv_zones->setSelected( item, true );
	m_lv_zones->blockSignals( false );
		
	m_cmd_ok->setEnabled( false );	
		
	KMFListViewItem* kmfitem = dynamic_cast<KMFListViewItem*> ( item );
	
	if ( ! kmfitem ) {
		kdDebug() << "No Item Selected!" << endl;	
		return;
	}
	
	if ( kmfitem != 0 && kmfitem->netfilterObject()->type() == NetfilterObject::KMFTARGET ) {
		m_target = kmfitem->target();
		m_lbl_currentTarget->setText( m_target->guiName() );
		kdDebug() << "Selected Target: " << m_target->guiName() << endl;
		m_cmd_ok->setEnabled( true );	
	} else {
		m_lbl_currentTarget->setText( i18n( "No Target Selected" ) );
		kdDebug() << "No Target Selected" << endl;
		m_cmd_ok->setEnabled( false );	
	}
	kdDebug() << "Laving slotNewItemSelected()" << endl;
}

void KMFSelectActiveTarget::slotCancel() {
	kdDebug() << "KMFSelectActiveTarget::slotCancel()" << endl;
	m_target = 0;
	TQDialog::reject();
}
void KMFSelectActiveTarget::slotOk() {
	kdDebug() << "KMFSelectActiveTarget::slotOk()" << endl;
	TQDialog::accept();
}

KMFTarget *KMFSelectActiveTarget::selectedTarget() {
	kdDebug() << "KMFSelectActiveTarget::slectedTarget()" << endl;
	return m_target;
}

}

#include "kmfselectactivetarget.moc"

