/***************************************************************************
 *   Copyright (C) 2005 by Christian Hubinger   *
 *   e9806056@student.tuwien.ac.at   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "mainwidget.h"

// TQt includes
#include <tqcolor.h>
#include <tqpushbutton.h>
#include <tqwidget.h>

// KDE includes
#include <kled.h>
#include <kpushbutton.h>

// Project Includes
#include "details.h"

MainWidget::MainWidget(TQWidget* parent, const char* name, WFlags fl)
: MainWidgetDesigner(parent,name,fl)
{
	m_ledActive->off();
	m_cmd_info->setEnabled( false );
	m_wid_details = new Details( 0 );
	connect( m_wid_details, TQ_SIGNAL( closing() ), this, TQ_SLOT ( slotDetailsClosed() ) );
	connect( this, TQ_SIGNAL( sigUpdateRuleCount( const TQString&, const TQString&, int ) ),
		m_wid_details, TQ_SLOT( slotUpdateRuleCount( const TQString&, const TQString&, int ) ) );
	connect( m_cmd_info, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotShowDetails() ) ) ;
}

MainWidget::~MainWidget()
{
}

void MainWidget::slotSetRunningStatus( bool on ) {
	m_ledActive->on();
	m_cmd_info->setEnabled( on );	
	if ( on ) {	
		m_ledActive -> setColor( TQColor(0, 255, 0) );
	} else {
		m_ledActive -> setColor( TQColor(255, 0, 0) );
	}
}


void MainWidget::slotDetailsClosed() {
	emit sigQueryDetails( false );
}

void MainWidget::slotShowDetails() {
	emit sigQueryDetails( true );
	m_wid_details->show();
	m_wid_details->raise();
}

#include "mainwidget.moc"

