//
// C++ Implementation: main
//
// Description: 
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <tqwidget.h>

#include <tdeapplication.h>
#include <tdeaboutapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdebug.h>


#include "../kmyfirewall/version.h"
#include "../kmyfirewall/kmfwidgets/kmfiptdocview.h"


#include "kmfsystray.h"
#include "kmfiptwatcher.h"
#include "details.h"


static const char description[] = I18N_NOOP( "KMFSysTray - IPTables monitor" );
 

static TDECmdLineOptions options[] = {
	{ "+[URL]", I18N_NOOP( "Files/URLs to Open." ), 0 },
	{ "--test ", I18N_NOOP("A short option which takes an argument."), 0 }, 
	{ 0, 0, 0}
};

int main( int argc, char *argv[] ) {
	TDEAboutData aboutData( "kmfsystray", I18N_NOOP( "KMFSysTray" ),
	                      KMYFIREWALL_VERSION, description, TDEAboutData::License_GPL,
	                      COPYRIGHT_STRING, 0, 0, "e9806056@student.tuwien.ac.at" );
	aboutData.addAuthor( "Christian Hubinger", 0, "e9806056@student.tuwien.ac.at" );
	aboutData.setHomepage( "http://kmyfirewall.sourceforge.net" );
	TDECmdLineArgs::init( argc, argv, &aboutData );
	TDECmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	TDEApplication a;
	// Details *mainWid = new Details( 0 );	

	KMFIPTDocView *mainWid = new KMFIPTDocView( 0 );
	KMFSysTray *st  = new KMFSysTray( mainWid );
	return a.exec();
}
