/***************************************************************************
    copyright            : (C) 2001-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef DATA_VECTORS_H
#define DATA_VECTORS_H

#include "ptrvector.h"

#include <tqmap.h>
#include <tqpair.h>

#include <ksharedptr.h>

namespace Tellico {
  typedef TQMap<TQString, TQString> StringMap;

  class Filter;
  typedef TDESharedPtr<Filter> FilterPtr;
  typedef Vector<Filter> FilterVec;

  namespace Data {
    class Collection;
    typedef TDESharedPtr<Collection> CollPtr;
    typedef TDESharedPtr<const Collection> ConstCollPtr;
    typedef Vector<Collection> CollVec;

    class Field;
    typedef TDESharedPtr<Field> FieldPtr;
    typedef TDESharedPtr<const Field> ConstFieldPtr;
    typedef Vector<Field> FieldVec;
    typedef FieldVec::Iterator FieldVecIt;
//    typedef Vector<ConstFieldPtr> ConstFieldVec;

    class Entry;
    typedef TDESharedPtr<Entry> EntryPtr;
    typedef TDESharedPtr<const Entry> ConstEntryPtr;
    typedef Vector<Entry> EntryVec;
    typedef EntryVec::Iterator EntryVecIt;
    typedef Vector<const Entry> ConstEntryVec;
    // complicated, I know
    // first item is a vector of all entries that got added in the merge process
    // second item is a pair of entries that had their track field modified
    // since a music collection is the only one that would actually merge entries
    typedef TQValueVector< TQPair<EntryPtr, TQString> > PairVector;
    typedef TQPair<Data::EntryVec, PairVector> MergePair;

    class Borrower;
    typedef TDESharedPtr<Borrower> BorrowerPtr;
    typedef Vector<Borrower> BorrowerVec;
  }
}

#endif
