/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _kpresenter_utils_h__
#define _kpresenter_utils_h__

#include "global.h"
#include "KoPointArray.h"
#include <tqcursor.h>
class TQPoint;
class TQColor;
class TQPainter;
class KoZoomHandler;
class KoSize;
class KoPoint;
class TQDomElement;
class KPrObject;

void drawFigure( LineEnd figure, TQPainter* painter, const KoPoint &coord, const TQColor & color,
                 int _w, float angle, KoZoomHandler*_zoomHandler );
void drawFigureWithOffset( LineEnd figure, TQPainter* painter, const TQPoint &coord, const TQColor & color,
                           int _w, float angle, KoZoomHandler*_zoomHandler );
void drawFigureWithOffset( LineEnd figure, TQPainter* painter, const KoPoint &coord, const TQColor &color,
                           int w, float angle, KoZoomHandler*_zoomHandler, bool begin);
KoSize getBoundingSize( LineEnd figure, int _w, const KoZoomHandler*_zoomHandler );
KoSize getOffset( LineEnd figure, int _w, float angle );
TQString lineEndBeginName( LineEnd type );
LineEnd lineEndBeginFromString( const TQString & name );
TQString lineEndBeginSvg( LineEnd element );
TQString saveOasisTimer( int second );
int loadOasisTimer( const TQString & timer );

class KPrUtils
{
public:
    static TQCursor penCursor(); // pen tool cursors
    static TQCursor rotateCursor(); // rotate tool cursor
};

int readOasisSettingsInt( const TQDomElement & element );
double readOasisSettingsDouble( const TQDomElement & element );
bool readOasisSettingsBool( const TQDomElement & element );
TQString readOasisSettingsString( const TQDomElement & element );

#endif
