/*
   KDChart - a multi-platform charting engine
   */

/****************************************************************************
 ** Copyright (C) 2001-2003 Klarälvdalens Datakonsult AB.  All rights reserved.
 **
 ** This file is part of the KDChart library.
 **
 ** This file may be distributed and/or modified under the terms of the
 ** GNU General Public License version 2 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.
 **
 ** Licensees holding valid commercial KDChart licenses may use this file in
 ** accordance with the KDChart Commercial License Agreement provided with
 ** the Software.
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** See http://www.klaralvdalens-datakonsult.se/?page=products for
 **   information about KDChart Commercial License Agreements.
 **
 ** Contact info@klaralvdalens-datakonsult.se if any conditions of this
 ** licensing are not clear to you.
 **
 **********************************************************************/
#ifndef __KDCHARTWIDGET_H__
#define __KDCHARTWIDGET_H__

#include <KDChartGlobal.h>
#include <KDChartTable.h>
#include <KDChartDataRegion.h>
#include <tqwidget.h>
#include <tqscrollview.h>
#include <tqpixmap.h>

/**
  \file KDChartWidget.h

  \brief Provids the entry point into the charting that most
  people will want to use.
  */

class KDChartParams;

class KDCHART_EXPORT KDChartWidget : public TQWidget
{
    TQ_OBJECT
  
    TQ_PROPERTY( bool activeData READ isActiveData WRITE setActiveData )
    TQ_PROPERTY( bool doubleBuffered READ isDoubleBuffered WRITE setDoubleBuffered )

public:
    KDChartWidget( TQWidget* parent = 0, const char* name = 0 );
    KDChartWidget( KDChartParams* params,
                   KDChartTableDataBase* data,
                   TQWidget* parent = 0, const char* name = 0 );
    ~KDChartWidget();

public slots:
    bool isActiveData() const;
    bool isDoubleBuffered() const;

    KDChartParams* params() const;
    KDChartTableDataBase* data() const;

    const KDChartDataRegionList* dataRegions() const { return &_dataRegions; }

    void setActiveData( bool active );
    void setDoubleBuffered( bool doublebuffered );
    void setParams( KDChartParams* params );
    void setData( KDChartTableDataBase* data );
    // use this method to paint to low resolution devices
    void paintTo( TQPainter& painter,
                  const TQRect* rect = 0 );
    // use this method to paint to high res devices like printers...
    void print( TQPainter& painter,
                const TQRect* rect = 0  );



signals:
    void dataLeftClicked( uint row, uint col );
    void dataLeftClicked( const TQPoint & pnt );
    void dataMiddleClicked( uint row, uint col );
    void dataMiddleClicked( const TQPoint & pnt );
    void dataRightClicked( uint row, uint col );
    void dataRightClicked( const TQPoint & pnt );
    void dataLeftPressed( uint row, uint col );
    void dataLeftPressed( const TQPoint & pnt );
    void dataMiddlePressed( uint row, uint col );
    void dataMiddlePressed( const TQPoint & pnt );
    void dataRightPressed( uint row, uint col );
    void dataRightPressed( const TQPoint & pnt );
    void dataLeftReleased( uint row, uint col );
    void dataLeftReleased( const TQPoint & pnt );
    void dataMiddleReleased( uint row, uint col );
    void dataMiddleReleased( const TQPoint & pnt );
    void dataRightReleased( uint row, uint col );
    void dataRightReleased( const TQPoint & pnt );
    void barsDisplayed( int barsDisplayed, int barsLeft );

protected:
    virtual void paintEvent( TQPaintEvent* event );
    virtual void mousePressEvent( TQMouseEvent* event );
    virtual void mouseReleaseEvent( TQMouseEvent* event );
    virtual void resizeEvent( TQResizeEvent* event );

private:
    KDChartParams* _params;
    KDChartTableDataBase* _data;
    bool _activeData;
    bool _doubleBuffered;
    TQPixmap _buffer;
    KDChartDataRegion* _mousePressedOnRegion;
    KDChartDataRegionList _dataRegions;
};

#endif
