#include "kchartWizardLabelsLegendPage.h"
#include "kchart_view.h"
#include "kchart_part.h"

#include <tqbuttongroup.h>
#include <tqlineedit.h>
#include <tqradiobutton.h>
#include <tqlabel.h>
#include <tdelocale.h>
#include <tdefontdialog.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqcolor.h>

#include "kchart_params.h"

namespace KChart
{

KChartWizardLabelsLegendPage::KChartWizardLabelsLegendPage( TQWidget* parent, KChartPart* chart ) :
    TQWidget( parent ),
    _chart( chart )
{
#if 0
    ytitle2=true;
#endif

    KDChartAxisParams leftparams;
    leftparams = _chart->params()->axisParams( KDChartAxisParams::AxisPosLeft );
    KDChartAxisParams bottomparams;
    bottomparams = _chart->params()->axisParams( KDChartAxisParams::AxisPosBottom );
    x_color=bottomparams.axisLineColor();
    y_color=leftparams.axisLineColor();
    xlabel=bottomparams.axisLabelsFont();
    ylabel=leftparams.axisLabelsFont();

    TQGridLayout *grid1 = new TQGridLayout(this,2,2,KDialog::marginHint(), KDialog::spacingHint());

    TQGroupBox* tmpTQGroupBox;
    tmpTQGroupBox = new TQGroupBox( this, "GroupBox_1" );
    tmpTQGroupBox->setFrameStyle( 49 );

    TQGridLayout *grid2 = new TQGridLayout(tmpTQGroupBox,4,4,KDialog::marginHint(), KDialog::spacingHint());

    TQLabel* titleLA = new TQLabel( i18n( "Title:" ),tmpTQGroupBox );
    grid2->addWidget(titleLA,0,0);

    _titleED = new TQLineEdit( tmpTQGroupBox );
    grid2->addWidget(_titleED,0,1);
    _titleED->setText( _chart->params()->header1Text() );

    titlefont = new TQPushButton( tmpTQGroupBox );
    grid2->addWidget(titlefont,0,2);
    titlefont->setText(i18n("Font..."));

    titlecolor=new KColorButton(tmpTQGroupBox);
    grid2->addWidget(titlecolor,0,3);
    title_color=_chart->params()->headerFooterColor( KDChartParams::HdFtPosHeader );
    titlecolor->setColor( title_color );


    TQLabel* xlabelLA = new TQLabel( i18n( "X-title:" ), tmpTQGroupBox );
    //xlabelLA->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(xlabelLA,1,0);

    _xlabelED = new TQLineEdit( tmpTQGroupBox );
    //_xlabelED->setEnabled(false); //Not supported by kdChart yet
    _xlabelED->setText(_chart->params()->axisTitle( KDChartAxisParams::AxisPosBottom));
    grid2->addWidget(_xlabelED,1,1);

    xtitlefont = new TQPushButton( tmpTQGroupBox );
    xtitlefont->setText(i18n("Font..."));
    //xtitlefont->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(xtitlefont,1,2);

    xtitlecolor=new KColorButton(tmpTQGroupBox);
    // PENDING(kalle) Put back in
    //  x_color=_chart->params()->XTitleColor;
    xtitlecolor->setColor( x_color );
    //xtitlecolor->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(xtitlecolor,1,3);


    TQLabel* ylabelLA = new TQLabel( i18n( "Y-title:" ), tmpTQGroupBox );
    //ylabelLA->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(ylabelLA,2,0);

    _ylabelED = new TQLineEdit( tmpTQGroupBox );
    //_ylabelED->setEnabled(false); //Not supported by kdChart yet
    _ylabelED->setText(_chart->params()->axisTitle( KDChartAxisParams::AxisPosLeft));
    grid2->addWidget(_ylabelED,2,1);


    ytitlefont = new TQPushButton( tmpTQGroupBox);
    ytitlefont->setText(i18n("Font..."));
    //ytitlefont->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(ytitlefont,2,2);

    ytitlecolor=new KColorButton(tmpTQGroupBox);
    //ytitlecolor->setEnabled(false); //Not supported by kdChart yet
    // PENDING(kalle) Put back in
    //   y_color=_chart->params()->YTitleColor;
    ytitlecolor->setColor( y_color );
    grid2->addWidget(ytitlecolor,2,3);

#if 0
    //ytitle2 doesn't work
    TQLabel* ylabelLA2 = new TQLabel( i18n( "Y-title 2:" ), tmpTQGroupBox );
    ylabelLA2->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(ylabelLA2,3,0);

    _ylabel2ED = new TQLineEdit( tmpTQGroupBox );
    _ylabel2ED->setEnabled(false); //Not supported by kdChart yet
    // PENDING(kalle) Put back in
    //   _ylabel2ED->setText(_chart->params()->ytitle2);
    grid2->addWidget(_ylabel2ED,3,1);

    ytitle2font = new TQPushButton( tmpTQGroupBox);
    ytitle2font->setText(i18n("Font..."));
    ytitle2font->setEnabled(false); //Not supported by kdChart yet
    grid2->addWidget(ytitle2font,3,2);

    ytitle2color=new KColorButton(tmpTQGroupBox);
    ytitle2color->setEnabled(false); //Not supported by kdChart yet
    // PENDING(kalle) Put back in
    //   y_color2=_chart->params()->YTitle2Color;
    ytitle2color->setColor( y_color2 );
    grid2->addWidget(ytitle2color,3,3);
#endif

    // PENDING(kalle) Put back in
    //   xlabel=_chart->params()->xTitleFont();
    //   ylabel=_chart->params()->yTitleFont();


    TQLabel* lab = new TQLabel( i18n( "Legend title:" ), tmpTQGroupBox );
    grid2->addWidget(lab,3,0);

    _legendTitleText = new TQLineEdit( tmpTQGroupBox );
    grid2->addWidget(_legendTitleText,3,1);
    _legendTitleText->setText( _chart->params()->legendTitleText() );


    legendTitleFont = new TQPushButton( tmpTQGroupBox );
    legendTitleFont->setText(i18n("Font..."));
    _legendTitleFont=_chart->params()->legendTitleFont();
    grid2->addWidget(legendTitleFont,3,2);

    legendTitleColor=new KColorButton(tmpTQGroupBox);
    _legendTitleColor=_chart->params()->legendTitleTextColor();
    legendTitleColor->setColor( _legendTitleColor );
    grid2->addWidget(legendTitleColor,3,3);


    lab = new TQLabel( i18n( "Legend text:" ), tmpTQGroupBox );
    grid2->addWidget(lab,4,0);

    legendTextFont = new TQPushButton( tmpTQGroupBox );
    _legendTextFont=_chart->params()->legendFont();
    legendTextFont->setText(i18n("Font..."));
    grid2->addWidget(legendTextFont,4,2);

    legendTextColor=new KColorButton(tmpTQGroupBox);
    _legendTextColor=_chart->params()->legendTextColor();
    legendTextColor->setColor( _legendTextColor );
    grid2->addWidget(legendTextColor,4,3);

    title=_chart->params()->header1Font();
    grid1->addWidget(tmpTQGroupBox,0,0);

    connect(xtitlefont,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeXLabelFont()));
    connect(ytitlefont,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeYLabelFont()));
#if 0
    connect(ytitle2font,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeY2LabelFont()));
#endif
    connect(titlefont,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeTitleFont()));
    connect(legendTitleFont,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeLegendTitleFont()));

    connect(legendTextFont,TQ_SIGNAL(clicked()),this,TQ_SLOT(changeLegendTextFont()));

    connect(xtitlecolor,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeXLabelColor(const TQColor &)));
    connect(ytitlecolor,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeYLabelColor(const TQColor &)));
    connect(titlecolor,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeTitleColor(const TQColor &)));
#if 0
    connect(ytitle2color,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeYTitle2Color(const TQColor &)));
#endif
    connect(legendTitleColor,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeLegendTitleColor(const TQColor &)));

    connect(legendTextColor,TQ_SIGNAL(changed( const TQColor & )),
            this,TQ_SLOT(changeLegendTextColor(const TQColor &)));

}


KChartWizardLabelsLegendPage::~KChartWizardLabelsLegendPage()
{
    //  _chart->removeAutoUpdate( preview );
}

void KChartWizardLabelsLegendPage::changeLegendTextFont()
{
    if (TDEFontDialog::getFont( _legendTextFont,false,this ) == TQDialog::Rejected )
        return;
}

void KChartWizardLabelsLegendPage::changeLegendTitleFont()
{
    if (TDEFontDialog::getFont( _legendTitleFont,false,this ) == TQDialog::Rejected )
        return;
}

void KChartWizardLabelsLegendPage::changeXLabelFont()
{
    if (TDEFontDialog::getFont( xlabel,false,this ) == TQDialog::Rejected )
        return;
}

void KChartWizardLabelsLegendPage::changeYLabelFont()
{
    if (TDEFontDialog::getFont( ylabel ,false,this ) == TQDialog::Rejected )
        return;
}

#if 0
void KChartWizardLabelsLegendPage::changeY2LabelFont()
{
    if (TDEFontDialog::getFont( ylabel2, false, this ) == TQDialog::Rejected )
        return;
}
#endif

void KChartWizardLabelsLegendPage::changeTitleFont()
{
    if (TDEFontDialog::getFont( title ,false,this ) == TQDialog::Rejected )
        return;

}

void KChartWizardLabelsLegendPage::changeLegendTextColor(const TQColor &_color)
{
    _legendTextColor=_color;
}

void KChartWizardLabelsLegendPage::changeXLabelColor(const TQColor &_color)
{
    x_color=_color;
}

void KChartWizardLabelsLegendPage::changeYLabelColor(const TQColor &_color)
{
    y_color=_color;
}

void KChartWizardLabelsLegendPage::changeTitleColor(const TQColor &_color)
{
    title_color=_color;
}

#if 0
void KChartWizardLabelsLegendPage::changeYTitle2Color(const TQColor &_color)
{
    y_color2=_color;
}
#endif

void KChartWizardLabelsLegendPage::changeLegendTitleColor(const TQColor &_color)
{
    _legendTitleColor=_color;
}

void KChartWizardLabelsLegendPage::paintEvent( TQPaintEvent * )
{
#if 0
    if( ytitle2 ) {
        _ylabel2ED->setEnabled(true);
        ytitle2color->setEnabled(true);
    }
    else {
        _ylabel2ED->setEnabled(false);
        ytitle2color->setEnabled(false);
    }
#endif
}

void KChartWizardLabelsLegendPage::apply(  )
{
    _chart->params()->setHeader1Text( _titleED->text() );

    // PENDING(kalle) Put back in
    //    _chart->params()->setXTitleFont(xlabel);
    //    _chart->params()->setYTitleFont(ylabel);
    //    _chart->params()->xtitle= _xlabelED->text();
    //    _chart->params()->ytitle= _ylabelED->text();
    //    _chart->params()->XTitleColor=x_color;
    //    _chart->params()->YTitleColor=y_color;
    //    _chart->params()->YTitle2Color=y_color2;
    //    _chart->params()->ytitle2=_ylabel2ED->text();

    _chart->params()->setHeaderFooterColor( KDChartParams::HdFtPosHeader, title_color );
    _chart->params()->setHeaderFooterFont(  KDChartParams::HdFtPosHeader, title, true, title.pointSize()*4 );
    _chart->params()->setAxisTitle( KDChartAxisParams::AxisPosBottom, _xlabelED->text() );
    _chart->params()->setAxisTitle( KDChartAxisParams::AxisPosLeft, _ylabelED->text() );

    _chart->params()->setLegendTitleText(_legendTitleText->text());
    _chart->params()->setLegendTitleTextColor(_legendTitleColor);
    _chart->params()->setLegendTitleFont(        _legendTitleFont,false);
    _chart->params()->setLegendTitleFontRelSize( _legendTitleFont.pointSize()*4 );
    _chart->params()->setLegendTextColor(_legendTextColor);
    _chart->params()->setLegendFont(        _legendTextFont,false);
    _chart->params()->setLegendFontRelSize( _legendTextFont.pointSize()*4 );

    KDChartAxisParams leftparams;
    leftparams   = _chart->params()->axisParams( KDChartAxisParams::AxisPosLeft );
    KDChartAxisParams bottomparams;
    bottomparams = _chart->params()->axisParams( KDChartAxisParams::AxisPosBottom );
    if( x_color.isValid() )
        bottomparams.setAxisLineColor( x_color );
    if( y_color.isValid() )
        leftparams.setAxisLineColor( y_color );
    if(bottomparams.axisLabelsFont()!=xlabel){
        bottomparams.setAxisLabelsFont(        xlabel,false );
        bottomparams.setAxisLabelsFontRelSize( xlabel.pointSize()*4 );
    }
    if(leftparams.axisLabelsFont()!=ylabel){
      leftparams.setAxisLabelsFont(        ylabel,false );
      leftparams.setAxisLabelsFontRelSize( ylabel.pointSize()*4 );
    }

    _chart->params()->setAxisParams( KDChartAxisParams::AxisPosBottom, bottomparams );
    _chart->params()->setAxisParams( KDChartAxisParams::AxisPosLeft, leftparams );
}

}  //KChart namespace

#include "kchartWizardLabelsLegendPage.moc"
