/* This file is part of the KDE project
   Copyright (C) 1999 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef GNUMERICFILTER_H
#define GNUMERICFILTER_H

#include <KoFilter.h>

#include <tqdatetime.h>
#include <tqdom.h>

namespace KSpread
{
class Cell;
class Sheet;
}

class GNUMERICFilter : public KoFilter
{
    TQ_OBJECT
  
 public:
    GNUMERICFilter(KoFilter *parent, const char *name, const TQStringList&);
    virtual ~GNUMERICFilter() {}

    virtual KoFilter::ConversionStatus convert( const TQCString& from, const TQCString& to );

enum borderStyle { Left, Right, Top, Bottom, Diagonal, Revdiagonal};
 private:
  class GnumericDate : public TQDate
  {
   public:
    static uint greg2jul( int y, int m, int d );
    static void jul2greg( double num, int & y, int & m, int & d );
    static TQTime getTime( double num );

  };

  void dateInit();
  TQString convertVars( TQString const & str, KSpread::Sheet * table ) const;
  void ParsePrintInfo( TQDomNode const & printInfo, KSpread::Sheet * table );
  void ParseFormat(TQString const & formatString, KSpread::Cell* kspread_cell);
  void setStyleInfo(TQDomNode * sheet, KSpread::Sheet * table);
  bool setType( KSpread::Cell* kspread_cell, TQString const & formatString, TQString & cell_content );
  void convertFormula( TQString & formula ) const;
    void importBorder( TQDomElement  border, borderStyle _style,  KSpread::Cell*cell);
    void ParseBorder( TQDomElement & gmr_styleborder, KSpread::Cell* kspread_cell );
    double parseAttribute( const TQDomElement &_element );

};
#endif // GNUMERICFILTER_H
