//
// C++ Implementation: kileuntitled
//
// Description: 
//
//
// Author: Jeroen Wijnhout <Jeroen.Wijnhout@kdemail.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "kileuntitled.h"

#include <tqregexp.h>
#include <tdelocale.h>

TQString KileUntitled::m_untitled = i18n("Untitled");
int KileUntitled::m_last = -1;

bool KileUntitled::isUntitled(const TQString &str)
{
    static TQRegExp reUntitled(m_untitled + " [0-9]+.*");
    return reUntitled.exactMatch(str);
}

TQString KileUntitled::next()
{
    ++m_last;
    return current();
}

TQString KileUntitled::current()
{
    return m_untitled + ' ' + TQString::number(m_last);
}

