/***************************************************************************
                          alsa-mixer-element.cpp  -  description
                             -------------------
    begin                : Mon Aug 15 2005
    copyright            : (C) 2005 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "alsa-mixer-element.h"

#include <knuminput.h>
#include <tqslider.h>
#include <tqlabel.h>
#include <tqcheckbox.h>

#include <math.h>

QAlsaMixerElement::QAlsaMixerElement(TQWidget *parent, const TQString &label, bool has_switch, bool has_volume)
    : AlsaMixerElementUI(parent),
      m_HasVolume(has_volume),
      m_HasSwitch(has_switch),
      m_dirty(false),
      m_ignore_updates(false)
{
    setLabel(label);
    setVolume(0);

    TQObject::connect(m_spinboxVolume, TQ_SIGNAL(valueChanged(int)),
                     this,            TQ_SLOT  (slotSpinboxValueChanged(int)));
    TQObject::connect(m_sliderVolume,  TQ_SIGNAL(valueChanged(int)),
                     this,            TQ_SLOT  (slotSliderValueChanged(int)));

    if (m_HasVolume) {
        TQObject::connect(m_checkboxOverride, TQ_SIGNAL(toggled(bool)),
                         m_spinboxVolume,    TQ_SLOT  (setEnabled(bool)));
        TQObject::connect(m_checkboxOverride, TQ_SIGNAL(toggled(bool)),
                         m_sliderVolume,     TQ_SLOT  (setEnabled(bool)));
    } else {
        m_spinboxVolume->hide();
        m_sliderVolume->hide();
    }
    if (m_HasSwitch) {
        TQObject::connect(m_checkboxOverride, TQ_SIGNAL(toggled(bool)),
                         m_checkboxActive,   TQ_SLOT  (setEnabled(bool)));
    } else {
        //m_checkboxActive->hide();
        m_checkboxActive->setEnabled(false);
        m_checkboxActive->setChecked(true);
    }

    connect(m_checkboxOverride, TQ_SIGNAL(toggled(bool)),     this, TQ_SLOT(slotSetDirty()));
    connect(m_checkboxActive,   TQ_SIGNAL(toggled(bool)),     this, TQ_SLOT(slotSetDirty()));
    connect(m_spinboxVolume,    TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(slotSetDirty()));
    connect(m_sliderVolume,     TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(slotSetDirty()));
}


QAlsaMixerElement::~QAlsaMixerElement()
{
}

float QAlsaMixerElement::getVolume() const
{
    return ((float)m_spinboxVolume->value())/100.0;
}

bool  QAlsaMixerElement::getActive() const
{
    return m_checkboxActive->isChecked();
}

bool  QAlsaMixerElement::getOverride() const
{
    return m_checkboxOverride->isChecked();
}

void QAlsaMixerElement::setLabel(const TQString &label)
{
    m_labelMixerElementName->setText(label);
}

void QAlsaMixerElement::setOverride(bool ov)
{
    m_ignore_updates = true;
    m_checkboxOverride->setChecked(ov);
    m_ignore_updates = false;
}

void QAlsaMixerElement::setActive(bool active)
{
    m_ignore_updates = true;
    m_checkboxActive->setChecked(active);
    m_ignore_updates = false;
}

void QAlsaMixerElement::setVolume(float vol)
{
    m_ignore_updates = true;
    int v = (int)rint(vol*100 + 0.5);
    m_sliderVolume->setValue(100 - v);
    m_spinboxVolume->setValue(v);
    m_ignore_updates = false;
}

void QAlsaMixerElement::slotSpinboxValueChanged(int v)
{
    m_sliderVolume->setValue(100-v);
}

void QAlsaMixerElement::slotSliderValueChanged(int v)
{
    m_spinboxVolume->setValue(100-v);
}


void QAlsaMixerElement::slotSetDirty()
{
    if (!m_dirty && !m_ignore_updates) {
        m_dirty = true;
        emit sigDirty();
    }
}


void QAlsaMixerElement::slotResetDirty()
{
    m_dirty = false;
}

#include "alsa-mixer-element.moc"
