//
// C++ Interface: k9avifile
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9AVIFILE_H
#define K9AVIFILE_H

#include <tqobject.h>
#include <tqdatetime.h>
#include <tqimage.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9Title;
class k9AviFile : public TQObject
{
TQ_OBJECT
  
public:
    k9AviFile(k9Title *parent = 0, const char *name = 0);

    ~k9AviFile();

	void setFileName ( const TQString& _value );
	TQString getFileName() const;

	void setStart ( const TQTime& _value );
	TQTime getStart() const;

	void setEnd ( const TQTime& _value );
	TQTime getEnd() const;

	void setLabel ( const TQString& _value );
	TQString getLabel() const;

	k9Title* getTitle() const;

	int getNum() const;

	void setPrevious ( k9AviFile* _value );
	k9AviFile* getPrevious() const;

	void setNext ( k9AviFile* _value );
	k9AviFile* getNext() const;

        void setBreakPrevious(bool _state);
        bool getBreakPrevious();

        void setBreakNext(bool _state);
        bool getBreakNext();

	void setImage(const TQImage& _value);
	TQImage getImage() const;
	

private:
    TQString m_fileName;
    TQTime m_start;
    TQString m_label;
    TQTime m_end;
    k9Title *m_title;
    TQImage m_image;
    int m_num;
    bool m_breakNext,m_breakPrevious;
    k9AviFile *m_previous;
    k9AviFile *m_next;
    void setTitle ( k9Title* _value );
signals:
    void aviFileUpdated(k9AviFile *_aviFile);
    void imageChanged(const TQImage &);
};

#endif
