//
// C++ Interface: k9avidecode
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9AVIDECODE_H
#define K9AVIDECODE_H

#include "k9common.h"
#include <tqobject.h>

extern "C" {
#include <libavformat/avformat.h>
#include <libavcodec/avcodec.h>
#include <libavutil/avutil.h>
#include <libavutil/time.h>
#include <libavutil/imgutils.h>
#include <libavutil/mathematics.h>
#include <libswscale/swscale.h>
};

#include <tqimage.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/


class k9AviDecode : public TQObject
{
TQ_OBJECT
  
public:
    k9AviDecode(TQObject *parent = 0, const char *name = 0);

    ~k9AviDecode();
    bool open(const TQString & _fileName);
    void readFrame(double _seconds);
    void seek(double _seconds);
    void close();
    double getDuration() const;
    bool opened() const;

    TQString getFileName() const;

    TQString getError() const;
	
private:
    AVFormatContext *m_FormatCtx;
    AVCodecContext *m_CodecCtx;
    AVCodec *m_Codec;
    AVFrame *m_Frame,*m_FrameRGB;
    uint8_t *m_buffer;
    int m_videoStream;
    bool m_opened;
    double m_duration;
    TQString m_fileName;
    TQString m_error;
    void SaveFrame(AVFrame *pFrame, int width, int height);
signals:
    void drawFrame(TQImage*);
};

#endif
