/* This file is based on tdefiledetailview.h from the KDE libs. Original
   copyright follows.
*/
/* This file is part of the KDE libraries
	Copyright (C) 1997 Stephan Kulow <coolo@kde.org>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.	If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/

#ifndef FILEDETAILVIEWITEM_H
#define FILEDETAILVIEWITEM_H

// KDE includes
#include <tdelistview.h>
#include <tdefileitem.h>
namespace Gwenview {

#define COL_NAME 0
#define COL_SIZE 1
#define COL_DATE 2
#define COL_PERM 3
#define COL_OWNER 4
#define COL_GROUP 5

class FileDetailViewItem : public TDEListViewItem
{
public:
	FileDetailViewItem( TQListView* parent, const TQString &text,
					   const TQPixmap &icon, KFileItem* fi )
		: TDEListViewItem( parent, text ), inf( fi ) {
		setPixmap( 0, icon );
		setText( 0, text );
	}

	FileDetailViewItem( TQListView* parent, KFileItem* fi )
		: TDEListViewItem( parent ), inf( fi ) {
		init();
	}

	FileDetailViewItem( TQListView* parent, const TQString &text,
					   const TQPixmap &icon, KFileItem* fi,
					   TQListViewItem* after)
		: TDEListViewItem( parent, after ), inf( fi ) {
		setPixmap( 0, icon );
		setText( 0, text );
	}
	
	~FileDetailViewItem() {
		inf->removeExtraData( listView() );
	}

	KFileItem* fileInfo() const { return inf; }

	virtual TQString key( int /*column*/, bool /*ascending*/ ) const { return m_key; }

	void setKey( const TQString& key ) { m_key = key; }

	TQRect rect() const
	{
		TQRect r = listView()->itemRect(this);
		return TQRect( listView()->viewportToContents( r.topLeft() ),
					  TQSize( r.width(), r.height() ) );
	}

	void init();
	virtual const TQPixmap* pixmap(int column) const;
	
private:
	KFileItem* inf;
	TQString m_key;
};

} // namespace
#endif

