/*
 * Copyright Max Judin, Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef REGWND_H
#define REGWND_H

#include <tqlistview.h>
#include <list>
#include <map>

class TQPopupMenu;
class RegisterViewItem;
class GroupingViewItem;
struct RegisterInfo;


class RegisterView : public TQListView
{
    TQ_OBJECT
public:
    RegisterView(TQWidget* parent, const char *name = 0L);
    ~RegisterView();

protected slots:
    void rightButtonClicked(TQListViewItem*, const TQPoint&, int);
    void slotModeChange(int);
    void updateRegisters(const std::list<RegisterInfo>&);

private:
    void paletteChange(const TQPalette& oldPal);
    void updateGroupVisibility();
    GroupingViewItem* findMatchingGroup(const TQString& regName);
    GroupingViewItem* findGroup(const TQString& groupName);
    TQPopupMenu* m_modemenu;
    typedef std::map<TQString,RegisterViewItem*> RegMap;
    RegMap m_registers;

friend class RegisterViewItem;
};

#endif // REGWND_H
