/***************************************************************************
    smb4ksambaoptionsinfo  -  This is a container class that carries
    various information of extra options for a specific host.
                             -------------------
    begin                : Mi Okt 18 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/


// application specific includes
#include "smb4ksambaoptionsinfo.h"
#include "smb4kshare.h"


Smb4KSambaOptionsInfo::Smb4KSambaOptionsInfo( const TQString &name )
: m_name( name ), m_remount( false ), m_port( -1 ),
#ifndef __FreeBSD__
m_filesystem( TQString() ), m_write_access( true ),
#endif
m_protocol( TQString() ), m_kerberos( false ),
m_uid( TQString() ), m_gid( TQString() )
{
}


Smb4KSambaOptionsInfo::Smb4KSambaOptionsInfo( Smb4KShare *share )
: m_name( share->name() ), m_remount( false ), m_port( -1 ),
#ifndef __FreeBSD__
m_filesystem( share->filesystem() ), m_write_access( true ),
#endif
m_protocol( TQString() ), m_kerberos( false ),
m_uid( TQString( "%1" ).arg( share->uid() ) ), m_gid( TQString( "%1" ).arg( share->gid() ) )
{
}



Smb4KSambaOptionsInfo::Smb4KSambaOptionsInfo( const Smb4KSambaOptionsInfo &info )
: m_name( info.itemName() ), m_remount( info.remount() ), m_port( info.port() ),
#ifndef __FreeBSD__
m_filesystem( info.filesystem() ), m_write_access( info.writeAccess() ),
#endif
m_protocol( info.protocol() ), m_kerberos( info.kerberos() ),
m_uid( info.uid() ), m_gid( info.gid() )
{
}


Smb4KSambaOptionsInfo::~Smb4KSambaOptionsInfo()
{
}


void Smb4KSambaOptionsInfo::setRemount( bool rm )
{
  m_remount = rm;
}


void Smb4KSambaOptionsInfo::setItemName( const TQString &name )
{
  m_name = name;
}


void Smb4KSambaOptionsInfo::setPort( int port )
{
  m_port = port;
}

void Smb4KSambaOptionsInfo::setProtocol( const TQString &p )
{
  if ( TQString::compare( p, "auto" ) != 0 )
  {
    m_protocol = p;
  }
  else
  {
    m_protocol = TQString();
  }
}


void Smb4KSambaOptionsInfo::setKerberos( bool krb )
{
  m_kerberos = krb;
}


int Smb4KSambaOptionsInfo::type()
{
  return m_name.contains( "/" ) == 3 ? Share : Host;
}


void Smb4KSambaOptionsInfo::setUID( const TQString &uid )
{
  m_uid = uid;
}


void Smb4KSambaOptionsInfo::setGID( const TQString &gid )
{
  m_gid = gid;
}

#ifndef __FreeBSD__
void Smb4KSambaOptionsInfo::setFilesystem( const TQString &fs )
{
  m_filesystem = fs;
}


void Smb4KSambaOptionsInfo::setWriteAccess( bool rw )
{
  m_write_access = rw;
}
#endif

