/***************************************************************************
                          item.cpp  -  description
                             -------------------
    begin                : Fri May 23 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdeglobal.h>
#include <kicontheme.h>

#include <tqfile.h>
#include <tqimage.h>
#include <tqtextstream.h>

#include "item.h"

Item::Item(const TQString& iconName, const TQString& cmd, const TQString& name, int minSize, int maxSize)
{
  iLoader = TDEGlobal::iconLoader();
  command = cmd;
  this->name = name;
  mCount = 0;
  mIndex = 0;
  mMIndex = 0;
  mClass = "";
  this->minSize = minSize;
  this->maxSize = maxSize;
  this->iconName = iconName;

  TQImage icon(iLoader->loadIcon(iconName, TDEIcon::NoGroup, 64).convertToImage());
  if (minSize <= maxSize) {
    int count = maxSize - minSize + 1;
    icons.setAutoDelete(true);

    for (int i = 0; i < count; i++) {
      if (i % SIZE_INC == 0) {
        icons.append(new TQPixmap(icon.smoothScale(minSize + i, minSize + i)));
      }
    }
  }

  id = 0;
  animed = false;
}

Item::Item(const TQString& fileName, int minSize, int maxSize)
{
  TQString line;
  TQFile in(fileName);
  in.open(IO_ReadOnly);
  mCount = 0;
  mIndex = 0;
  mMIndex = 0;
  mClass = "";
  if (in.readLine(line, MAX_LEN) != -1) {
    if (line.contains("[Desktop Entry]", false) > 0) {
      while (in.readLine(line, MAX_LEN) != -1) {
        if (line.startsWith("Exec=")) {
          command = line.mid(5).stripWhiteSpace();
        }
        else if(line.startsWith("Icon=")) {
          iconName = line.mid(5).stripWhiteSpace();
        }
        else if(line.startsWith("Name=")) {
          name = line.mid(5).stripWhiteSpace();
        }
      }
    }
  }
  in.close();
  iLoader = TDEGlobal::iconLoader();
  this->minSize = minSize;
  this->maxSize = maxSize;
  this->filename = fileName;
  mCount = 0;
  mIndex = 0;
  mMIndex = 0;
  mClass = "";
  TQImage icon(iLoader->loadIcon(iconName, TDEIcon::NoGroup, 64).convertToImage());
  if (minSize <= maxSize) {
    int count = maxSize - minSize + 1;
    icons.setAutoDelete(true);
    for (int i = 0; i < count; i++) {
      if (i % SIZE_INC == 0) {
        icons.append(new TQPixmap(icon.smoothScale(minSize + i, minSize + i)));
      }
    }
  }

  id = 0;
  animed = false;
}

Item::Item(const TQPixmap& iconBig, WId id, const TQString& name, int minSize, int maxSize, bool wi)
{
  setId(id);
  this->name = name;
  mCount = 0;
  mIndex = 0;
  mMIndex = 0;
  mClass = "";
  this->minSize = minSize;
  this->maxSize = maxSize;
  command = "";
  wIcon = wi;
  TQImage icon(iconBig.convertToImage());
  if(minSize <= maxSize) {
    int count = maxSize - minSize + 1;
    icons.setAutoDelete(true);
    for (int i = 0; i < count; i++) {
      if (i % SIZE_INC == 0) {
        if (wi) {
          icons.append(new TQPixmap(icon));
        }
        else {
          icons.append(new TQPixmap(icon.scale(minSize + i, minSize + i)));
        }
      }
    }
  }
  animed = false;
}

Item::~Item()
{
}

TQPixmap* Item::getIcon(int size)
{
  if ((size >= minSize) && (size <= maxSize)) {
    int d = size - minSize;
    return icons.at(d / SIZE_INC);
  }
  else {
    return 0;
  }
}

TQString Item::getCommand()
{
  return command;
}

TQString Item::getName()
{
  return name;
}

TQCString Item::getClass()
{
  return mClass;
}

int Item::getCount()
{
  return mCount;
}

int Item::getIndex()
{
  return mIndex;
}

int Item::getMIndex()
{
  return mMIndex;
}

TQString Item::getFilename()
{
  return filename;
}

WId Item::getId()
{
  return id;
}

void Item::setId(WId newId)
{
  info = KWin::windowInfo(newId, 0, NET::WM2AllowedActions);
  id = newId;
}

void Item::setIcon(const TQPixmap& iconBig)
{
  icons.clear();
  TQImage icon(iconBig.convertToImage());

  int count = maxSize - minSize + 1;
  icons.setAutoDelete(true);
   
  for (int i = 0; i < count; i++) {
    if (i % SIZE_INC == 0) {
      icons.append(new TQPixmap(icon.smoothScale(minSize + i, minSize + i)));
    }
  }
}

void Item::setName(const TQString& newName)
{
  name = newName;
}

void Item::setClass(const TQCString& newClass)
{
  mClass = newClass;
}

void Item::setCount(int newCount)
{
  mCount = newCount;
}

void Item::setIndex(int newIndex)
{
  mIndex = newIndex;
}

void Item::setMIndex(int newIndex)
{
  mMIndex = newIndex;
}

bool Item::isAnimed()
{
  return this->animed;
}

void Item::anim(bool param)
{
  this->animed = param;
}
