/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEPLOTDIALOG_H
#define QALCULATEPLOTDIALOG_H

#include <vector>
#include <string>
#include <kdialogbase.h>
#include <tqmap.h>
#include <tqstring.h>

class KLineEdit;
class TQCheckBox;
class TQRadioButton;
class TQSpinBox;
class TQButtonGroup;
class KComboBox;
class TQPushButton;
class TQTabWidget;
class TDEListView;
class TQLabel;
class TQListViewItem;
class QalculateExpressionEdit;

#include "qalculate_tde_utils.h"

/**
@author Niklas Knutsson
*/
class QalculatePlotDialog : public KDialogBase {

	TQ_OBJECT

public:

	QalculatePlotDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculatePlotDialog();

	TQLabel *xVariableLabel;
	KLineEdit *seriesTitleEdit, *xVariableEdit, *minEdit, *maxEdit, *stepSizeEdit, *titleEdit, *xLabelEdit, *yLabelEdit;
	QalculateExpressionEdit *expressionEdit;
	TQCheckBox *rowsButton, *gridButton, *fullBorderButton, *logXButton, *logYButton;
	TQRadioButton *functionButton, *vectorMatrixButton, *pairedMatrixButton, *primaryButton, *secondaryButton, *samplingRateButton, *stepSizeButton, *colorButton, *monochromeButton;
	TQSpinBox *samplingRateBox, *logXBox, *logYBox;
	TQButtonGroup *typeGroup, *rangeGroup;
	KComboBox *styleCombo, *smoothingCombo, *legendPlacementCombo;
	TQPushButton *addButton, *modifyButton, *removeButton, *applyRangeButton, *applyAppearanceButton;
	TQTabWidget *tabs;
	TDEListView *seriesView;

	bool generatePlot(PlotParameters &pp, std::vector<MathStructure> &y_vectors, std::vector<MathStructure> &x_vectors, std::vector<PlotDataParameters*> &pdps);
	void generatePlotSeries(MathStructure **x_vector, MathStructure **y_vector, int type, std::string str, std::string str_x);

	TQMap<TQListViewItem*, int> itemStyle;
	TQMap<TQListViewItem*, int> itemSmoothing;
	TQMap<TQListViewItem*, int> itemType;
	TQMap<TQListViewItem*, int> itemAxis;
	TQMap<TQListViewItem*, bool> itemRows;
	TQMap<TQListViewItem*, MathStructure*> itemXVector;
	TQMap<TQListViewItem*, MathStructure*> itemYVector;
	TQMap<TQListViewItem*, TQString> itemXVariable;
	
protected slots:
	
	void slotHelp();	

public slots:

	void onClosing();
	void seriesItemRenamed(TQListViewItem*, const TQString&, int);
	void seriesSelected();
	void rangeTypeChanged(int);
	void typeChanged(int);
	void savePlot();
	void expressionActivated();
	void addSeries();
	void modifySeries();
	void removeSeries();
	void applyRange();
	void applyAppearance();
	void updatePlot();
	void saveMode();

};

#endif
