/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz <peter.penz@gmx.at>                  *
 *   Copyright (C) 2006 by Gregor Kališnik <gregor@podnapisi.net>          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "filterbar.h"

#include <tqlabel.h>
#include <tqlayout.h>

#include <kdialog.h>
#include <tdelocale.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <kiconloader.h>

#include "dolphin.h"

FilterBar::FilterBar(TQWidget *parent, const char *name) :
    TQWidget(parent, name)
{
    const int gap = 3;

    TQVBoxLayout* foo = new TQVBoxLayout(this);
    foo->addSpacing(gap);

    TQHBoxLayout* layout = new TQHBoxLayout(foo);
    layout->addSpacing(gap);

    m_filter = new TQLabel(i18n("Filter:"), this);
    layout->addWidget(m_filter);
    layout->addSpacing(KDialog::spacingHint());

    m_filterInput = new KLineEdit(this);
    layout->addWidget(m_filterInput);

    m_close = new KPushButton(this);
    m_close->setIconSet(SmallIcon("window-close"));
    m_close->setFlat(true);
    layout->addWidget(m_close);
    layout->addSpacing(gap);

    connect(m_filterInput, TQ_SIGNAL(textChanged(const TQString&)),
            this, TQ_SIGNAL(signalFilterChanged(const TQString&)));
    connect(m_close, TQ_SIGNAL(clicked()), this, TQ_SLOT(hide()));
    connect(m_close, TQ_SIGNAL(clicked()),
            &Dolphin::mainWin(), TQ_SLOT(slotShowFilterBarChanged()));
}

FilterBar::~FilterBar()
{
}

void FilterBar::hide()
{
    m_filterInput->clear();
    m_filterInput->clearFocus();
    TQWidget::hide();
}

void FilterBar::show()
{
    m_filterInput->setFocus();
    TQWidget::show();
}

void FilterBar::keyReleaseEvent(TQKeyEvent* event)
{
    TQWidget::keyReleaseEvent(event);
    if ((event->key() == TQt::Key_Escape)) {
        hide();
        Dolphin::mainWin().slotShowFilterBarChanged();
    }
}

#include "filterbar.moc"
