/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004 Alexander Dymo <cloudtemple@mskat.net>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "fontedit.h"
#include "editoritem.h"

#include <tqpushbutton.h>
#include <tqpainter.h>
#include <tqlayout.h>
#include <tqvariant.h>
#include <tqfont.h>
#include <tqfontmetrics.h>
#include <tqlabel.h>
#include <tqtooltip.h>

#include <tdeversion.h>
#include <tdefontrequester.h>
#include <tdeaccelmanager.h>
#include <tdelocale.h>

//! @internal
//! reimplemented to better button and label's positioning

namespace KoProperty {

class FontEditRequester : public TDEFontRequester
{
	public:
		FontEditRequester(TQWidget* parent)
			: TDEFontRequester(parent)
		{
			label()->setPaletteBackgroundColor(palette().active().base());
			label()->setMinimumWidth(0);
			label()->setFrameShape(TQFrame::Box);
			label()->setIndent(-1);
#if TDE_VERSION >= TDE_MAKE_VERSION(3,4,0)
			label()->setFocusPolicy(TQWidget::ClickFocus);
			TDEAcceleratorManager::setNoAccel(label());
#endif
			layout()->remove(label());
			layout()->remove(button());//->reparent(this, 0, TQPoint(0,0));
			delete layout();
			button()->setText(i18n("..."));
			TQToolTip::add(button(), i18n("Change font"));
			button()->setFocusPolicy(TQWidget::NoFocus);
			button()->setSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Fixed);
			TQFontMetrics fm(button()->font());
			button()->setFixedWidth(fm.width(button()->text()+' '));
		}
		virtual void resizeEvent(TQResizeEvent *e)
		{
			TDEFontRequester::resizeEvent(e);
			label()->move(0,0);
			label()->resize(e->size()-TQSize(button()->width(),-1));
			button()->move(label()->width(),0);
			button()->setFixedSize(button()->width(), height());
		}
};

}

using namespace KoProperty;

FontEdit::FontEdit(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	m_edit = new FontEditRequester(this);
	m_edit->setMinimumHeight(5);
	setEditor(m_edit);
	setFocusWidget(m_edit->label());
	connect(m_edit, TQ_SIGNAL(fontSelected(const TQFont& )), this, TQ_SLOT(slotValueChanged(const TQFont&)));
}

FontEdit::~FontEdit()
{}

TQVariant
FontEdit::value() const
{
	return m_edit->font();
}

static TQString sampleText(const TQVariant &value)
{
	TQFontInfo fi(value.toFont());
	return fi.family() + (fi.bold() ? " " + i18n("Bold") : TQString()) +
		(fi.italic() ? " " + i18n("Italic") : TQString()) +
		" " + TQString::number(fi.pointSize());
}

void
FontEdit::setValue(const TQVariant &value, bool emitChange)
{
	m_edit->blockSignals(true);
	m_edit->setFont(value.toFont());
	m_edit->blockSignals(false);
	m_edit->setSampleText(sampleText(value));
	if (emitChange)
		emit valueChanged(this);
}

void
FontEdit::drawViewer(TQPainter *p, const TQColorGroup &, const TQRect &r, const TQVariant &value)
{
	p->eraseRect(r);
	p->setFont(value.toFont());
	TQRect r2(r);
	r2.setLeft(r2.left()+KPROPEDITOR_ITEM_MARGIN);
	r2.setBottom(r2.bottom()+1);
	p->drawText(r2, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, sampleText(value));
}

void
FontEdit::slotValueChanged(const TQFont &)
{
	emit valueChanged(this);
}

bool
FontEdit::eventFilter(TQObject* watched, TQEvent* e)
{
	if(e->type() == TQEvent::KeyPress) {
		TQKeyEvent* ev = static_cast<TQKeyEvent*>(e);
		if(ev->key() == Key_Space) {
			m_edit->button()->animateClick();
			return true;
		}
	}
	return Widget::eventFilter(watched, e);
}

void
FontEdit::setReadOnlyInternal(bool readOnly)
{
	setVisibleFlag(!readOnly);
}

#include "fontedit.moc"
