/***************************************************************************
                          kmymoneybriefschedule.h  -  description
                             -------------------
    begin                : Sun Jul 6 2003
    copyright            : (C) 2000-2003 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMYMONEYBRIEFSCHEDULE_H
#define KMYMONEYBRIEFSCHEDULE_H


// ----------------------------------------------------------------------------
// TQt Includes
#include <tqwidget.h>
#include <tqstringlist.h>

// ----------------------------------------------------------------------------
// TDE Includes

// ----------------------------------------------------------------------------
// Project Includes
#include "../widgets/kschedulebriefwidget.h"
#include "../mymoney/mymoneyfile.h"

/**
  *@author Michael Edwardes
  */

class KMyMoneyBriefSchedule : public kScheduleBriefWidget  {
   TQ_OBJECT
  
public: 
  KMyMoneyBriefSchedule(TQWidget *parent=0, const char *name=0);
  ~KMyMoneyBriefSchedule();
  void setSchedules(TQValueList<MyMoneySchedule> list, const TQDate& date);

signals:
  void enterClicked(const MyMoneySchedule&, const TQDate&);
  void skipClicked(const MyMoneySchedule&, const TQDate&);

protected slots:
  void slotPrevClicked();
  void slotNextClicked();
  void slotEnterClicked();
  void slotSkipClicked();

private:
  TQValueList<MyMoneySchedule> m_scheduleList;
  unsigned int m_index;
  TQDate m_date;

  void loadSchedule();
};

#endif
