/*
	msystemtray.h - A system tray icon
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSYSTEMTRAY_H__
#define __MSYSTEMTRAY_H__

#include <ksystemtray.h>

class KPixmap;

#define ks_tray MSystemTray::getInstance()

/** @short A system tray icon. */
class MSystemTray: public KSystemTray
{
	TQ_OBJECT
public:
	/**
	 * System tray icon modes.
	 */
	enum Mode {
		Always = 0, /**< Always visible. */
		IfActive = 1, /**< Visible if action is active. */
		Never = 2  /**< Always hidden. */
	};

	/**
	 * Destructor.
	 */
	virtual ~MSystemTray();

	/**
	 * Flashes the icon.
	 */
	void flashIcon();

	/**
	 * Constructs and returns a singleton instance
	 * of the system tray icon.
	 */
	inline static MSystemTray *getInstance()
	{
		if (!_instance)
			_instance = new MSystemTray();

		return _instance;
	}

	/**
	 * Returns @c true if the instance of
	 * the system tray was created.
	 */
	inline static bool isInstance() { return _instance; }

	/**
	 * Switches icon between idle and active states.
	 * @param yes If @c true the state is "idle" (normal icon);
	 * otherwise the state is "active" (highlighted icon)
	 */
	void setActive(const bool yes);

	/**
	 * Returns the system tray icon mode.
	 */
	static inline Mode mode() { return _mode; }

	/**
	 * Sets system tray icon mode to @p mode.
	 */
	static void setMode(const Mode mode);
protected:
	/**
	 * Overriden to handle middle button click; displays the actions menu.
	 * @param e A mouse event
	 */
	virtual void mousePressEvent(TQMouseEvent *e);
private:
	// icon stuff
	bool
		_active,
		_incFade;
	double _fadeValue;
	int _flashCount;
	KPixmap *_flashIcon;
	static Mode _mode;
	TQPixmap *_saveIcon;
	TQTimer
		*_fadeTimer,
		*_flashTimer;
	static MSystemTray *_instance;
	MSystemTray();
private slots:
	void slotFade();
	void slotFlashTimeout();
};

#endif // __MSYSTEMTRAY_H__
