/*
 *   pageWidget.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "pageWidget.h"

#include <tdeconfig.h>
#include <tdelistview.h>

#include "kioskdata.h"
#include "kioskrun.h"

ComponentActionItem::ComponentActionItem( TQListView * parent, ComponentAction *action, int index)
 : TQCheckListItem(parent, action->caption, TQCheckListItem::CheckBox),
   m_action(action), m_index(index)
{

}

int ComponentActionItem::compare ( TQListViewItem * i, int, bool ) const 
{
   ComponentActionItem *cai = static_cast<ComponentActionItem*>(i);
   if (m_index == cai->m_index)
      return 0;
   if (m_index < cai->m_index)
      return -1;
   return 1;
}

PageWidget::PageWidget(TQWidget *me)
{
  m_widget = me;
}

PageWidget::~PageWidget()
{
}

void
PageWidget::fillActionList(TDEListView *listView, ComponentData *componentData)
{
  int index = 0;
  for(ComponentAction *action = componentData->actions.first(); action;
      action = componentData->actions.next())
  {
     ComponentActionItem *item = new ComponentActionItem(listView, action, index++);
     if (index == 1)
        item->setSelected(true);
     if (action->type == ComponentAction::ActRestrict)
     {
        TQString file = action->file;
        if (file.isEmpty())
           file = "kdeglobals";
        TDEConfig *cfg = KioskRun::self()->configFile(file);
        cfg->setGroup("KDE Action Restrictions");
        bool restricted = !cfg->readBoolEntry(action->key, true);
        item->setOn(restricted);
     }
     else if (action->type == ComponentAction::ActResource)
     {
        TQString file = action->file;
        if (file.isEmpty())
           file = "kdeglobals";
        TDEConfig *cfg = KioskRun::self()->configFile(file);
        cfg->setGroup("KDE Resource Restrictions");
        bool restricted = !cfg->readBoolEntry(action->key, true);
        item->setOn(restricted);
     }
     else if (action->type == ComponentAction::ActModule)
     {
        TQString file = "kdeglobals";
        TDEConfig *cfg = KioskRun::self()->configFile(file);
        cfg->setGroup("KDE Control Module Restrictions");
        bool restricted = !cfg->readBoolEntry(action->key, true);
        item->setOn(restricted);
     }
     else if (action->type == ComponentAction::ActImmutable)
     {
        TQString file = action->file;
        if (file.isEmpty())
           file = "kdeglobals";
        TQString group = action->group;
        bool immutable = KioskRun::self()->isConfigImmutable(file, group);
tqWarning("File = %s Group = %s Immutable = %s", file.latin1(), group.latin1(), immutable ? "true" : "false");
        item->setOn(immutable);
     }
     else if (action->type == ComponentAction::ActCustom)
     {
        bool checked = KioskRun::self()->lookupCustomAction(action->key);
        item->setOn(checked);
     }
     else if (action->type == ComponentAction::ActConfig)
     {
        TQString file = action->file;
        if (file.isEmpty())
           file = "kdeglobals";
        TDEConfig *cfg = KioskRun::self()->configFile(file);
        cfg->setGroup(action->group);
        bool checked = cfg->readBoolEntry(action->key, action->defaultValue);
        item->setOn(checked);
     }
  }
  KioskRun::self()->flushConfigCache();
}

void
PageWidget::saveActionListItem(ComponentAction *action, bool b)
{
  if (action->type == ComponentAction::ActRestrict)
  {
     TQString file = action->file;
     if (file.isEmpty())
        file = "kdeglobals";
     TDEConfig *cfg = KioskRun::self()->configFile(file);
     cfg->setGroup("KDE Action Restrictions");
        
     bool allowed = !b; // reverse logic
     if (cfg->readBoolEntry(action->key, true) != allowed)
     {
        cfg->writeEntry(action->key, allowed);
        KioskRun::self()->scheduleSycocaUpdate();
     }
  }
  else if (action->type == ComponentAction::ActResource)
  {
     TQString file = action->file;
     if (file.isEmpty())
        file = "kdeglobals";
     TDEConfig *cfg = KioskRun::self()->configFile(file);
     cfg->setGroup("KDE Resource Restrictions");
        
     bool allowed = !b; // reverse logic
     if (cfg->readBoolEntry(action->key, true) != allowed)
     {
        cfg->writeEntry(action->key, allowed);
        KioskRun::self()->scheduleSycocaUpdate();
     }
  }
  else if (action->type == ComponentAction::ActModule)
  {
     TQString file = "kdeglobals";
     TDEConfig *cfg = KioskRun::self()->configFile(file);
     cfg->setGroup("KDE Control Module Restrictions");

     bool allowed = !b; // reverse logic
     if (cfg->readBoolEntry(action->key, true) != allowed)
     {
        cfg->writeEntry(action->key, allowed);
        KioskRun::self()->scheduleSycocaUpdate();
     }
  }
  else if (action->type == ComponentAction::ActImmutable)
  {
     TQString file = action->file;
     if (file.isEmpty())
        file = "kdeglobals";
     TQString group = action->group;
     KioskRun::self()->setConfigImmutable(file, group, b);
  }
  else if (action->type == ComponentAction::ActCustom)
  {
     KioskRun::self()->setCustomAction(action->key, b);
  }
  else if (action->type == ComponentAction::ActConfig)
  {
     TQString file = action->file;
     if (file.isEmpty())
        file = "kdeglobals";
     TDEConfig *cfg = KioskRun::self()->configFile(file);
     cfg->setGroup(action->group);
        
     if (cfg->readBoolEntry(action->key, action->defaultValue) != b)
     {
        cfg->writeEntry(action->key, b);
        KioskRun::self()->scheduleSycocaUpdate();
     }
  }
  
  for(ComponentAction *subAction = action->subActions.first();
      subAction; subAction = action->subActions.next())
  {
     saveActionListItem(subAction, b);
  }
}

bool
PageWidget::saveActionListChanges(TDEListView *listView)
{
  for(ComponentActionItem *item = static_cast<ComponentActionItem*>(listView->firstChild()); 
      item; item = static_cast<ComponentActionItem*>(item->nextSibling()))
  {
     saveActionListItem(item->action(), item->isOn());
  }
  return KioskRun::self()->flushConfigCache();
}
