/***************************************************************************
                     kocrbase.cpp - base dialog for ocr
                             -------------------
    begin                : Fri Now 10 2000
    copyright            : (C) 2000 by Klaas Freitag
    email                : freitag@suse.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *  This file may be distributed and/or modified under the terms of the    *
 *  GNU General Public License version 2 as published by the Free Software *
 *  Foundation and appearing in the file COPYING included in the           *
 *  packaging of this file.                                                *
 *
 *  As a special exception, permission is given to link this program       *
 *  with any version of the KADMOS ocr/icr engine of reRecognition GmbH,   *
 *  Kreuzlingen and distribute the resulting executable without            *
 *  including the source code for KADMOS in the source distribution.       *
 *
 *  As a special exception, permission is given to link this program       *
 *  with any edition of TQt, and distribute the resulting executable,       *
 *  without including the source code for TQt in the source distribution.   *
 *                                                                         *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqfileinfo.h>
#include <tqtooltip.h>
#include <tdeio/job.h>
#include <tdeio/previewjob.h>

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kanimwidget.h>
#include <kseparator.h>
#include <tdemessagebox.h>
#include <kactivelabel.h>
#include <tqhbox.h>
#include <tqvbox.h>

#include "resource.h"
#include "kocrbase.h"
#include "ksaneocr.h"
#include "kookaimage.h"

#include <kscanslider.h>
#include <kstandarddirs.h>
#include <tdefilemetainfo.h>
#include <ksconfig.h>
#include <tqstringlist.h>
#include <tqcolor.h>
#include <tqgrid.h>
#include <tqsizepolicy.h>
#include <tqgroupbox.h>
#include <tqcheckbox.h>

KOCRBase::KOCRBase( TQWidget *parent, KSpellConfig *spellConfig,
                    KDialogBase::DialogType face )
   :KDialogBase( face, i18n("Optical Character Recognition"),
		 User2|Close|User1, User1, parent,0, false, true,
		 KGuiItem( i18n("Start OCR" ), "launch",
			   i18n("Start the Optical Character Recognition process" )),
                 KGuiItem( i18n("Cancel" ), "stopocr",
			   i18n("Stop the OCR Process" ))),
    m_animation(0L),
    m_metaBox(0L),
    m_imgHBox(0L),
    m_previewPix(0L),
    m_currImg(0L),
    m_spellConfig(spellConfig),
    m_wantSpellCfg(true),
    m_userWantsSpellCheck(true),
    m_cbWantCheck(0L),
    m_gbSpellOpts(0L)
{
    kdDebug(28000) << "OCR Base Dialog!" << endl;
    // Layout-Boxes

    TDEConfig *konf = TDEGlobal::config ();
    TDEConfigGroupSaver gs( konf, CFG_OCR_TDESPELL );
    m_userWantsSpellCheck = konf->readBoolEntry(CFG_WANT_TDESPELL, true);

    /* Connect signals which disable the fields and store the configuration */
    connect( this, TQ_SIGNAL( user1Clicked()), this, TQ_SLOT( writeConfig()));
    connect( this, TQ_SIGNAL( user1Clicked()), this, TQ_SLOT( startOCR() ));
    connect( this, TQ_SIGNAL( user2Clicked()), this, TQ_SLOT( stopOCR() ));
    m_previewSize.setWidth(200);
    m_previewSize.setHeight(300);

    enableButton( User1, true );   /* start ocr */
    enableButton( User2, false );  /* Cancel    */
    enableButton( Close, true );
}


KAnimWidget* KOCRBase::getAnimation(TQWidget *parent)
{
   if( ! m_animation )
   {
      m_animation = new KAnimWidget( TQString("kde"), 48, parent, "ANIMATION" );
   }
   return( m_animation );
}

EngineError KOCRBase::setupGui()
{
    ocrIntro();
    imgIntro();
    if( m_wantSpellCfg ) spellCheckIntro();

    return ENG_OK;
}

void KOCRBase::imgIntro()
{
    m_imgPage = addVBoxPage( i18n("Image") );
    (void) new TQLabel( i18n("Image Information"), m_imgPage );

    // Caption - Label and image
    m_imgHBox = new TQHBox( m_imgPage );

    m_imgHBox->setSpacing( KDialog::spacingHint());

    m_previewPix = new TQLabel( m_imgHBox );
    m_previewPix->setPixmap(TQPixmap());
    m_previewPix->setFixedSize(m_previewSize);
    m_previewPix->setAlignment( TQt::AlignCenter );
    m_previewPix->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
    // m_previewPix->resize(m_previewSize);

    /* See introduceImage where the meta box is filled with data from the
     * incoming widget.
     */
    m_metaBox = new TQVBox( m_imgHBox );
}

/*
 * This creates a Tab OCR
 */
void KOCRBase::ocrIntro( )
{
    m_ocrPage = addVBoxPage( i18n("OCR") );

    // Caption - Label and image
    /* labelstring */
    (void) new TQLabel( i18n("<b>Starting Optical Character Recognition with %1</b><p>").
                       arg( ocrEngineName() ), m_ocrPage );
    // Find the kadmos logo and display if available
    TDEStandardDirs stdDir;
    TQString logo = stdDir.findResource( "data", "kooka/pics/" + ocrEngineLogo() );

    kdDebug(28000)<< "Reading logo " << logo << endl;
    TQPixmap pix;
    TQWidget *pa = m_ocrPage;

    if( pix.load( logo ))
    {
        TQHBox *hb_cap = new TQHBox( m_ocrPage );
        hb_cap->setSpacing( KDialog::spacingHint());

        TQLabel *imgLab = new TQLabel( hb_cap );
        imgLab->setAlignment( TQt::AlignHCenter | TQt::AlignTop  );
        imgLab->setPixmap( pix );
        pa = hb_cap;
    }

    (void) new KActiveLabel( ocrEngineDesc(), pa );
}


void KOCRBase::spellCheckIntro()
{
    m_spellchkPage = addVBoxPage( i18n("Spell-checking") );

    /* Want the spell checking at all? Checkbox here */
    TQGroupBox *gb1 = new TQGroupBox( 1, TQt::Horizontal, i18n("OCR Post Processing"), m_spellchkPage );
    m_cbWantCheck = new TQCheckBox( i18n("Enable spell-checking for validation of the OCR result"),
                                   gb1 );
    /* Spellcheck options */
    m_gbSpellOpts = new TQGroupBox( 1, TQt::Horizontal, i18n("Spell-Check Options"),
                                   m_spellchkPage );

    KSpellConfig *sCfg = new KSpellConfig( m_gbSpellOpts, "SPELLCHK", m_spellConfig, false );
    /* A space eater */
    TQWidget *spaceEater = new TQWidget(m_spellchkPage);
    spaceEater->setSizePolicy( TQSizePolicy( TQSizePolicy::Ignored, TQSizePolicy::Ignored ));

    /* connect toggle button */
    connect( m_cbWantCheck, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slWantSpellcheck(bool)));
    m_cbWantCheck->setChecked( m_userWantsSpellCheck );
    m_gbSpellOpts->setEnabled( m_userWantsSpellCheck );
    m_spellConfig = sCfg;

    connect( sCfg, TQ_SIGNAL(configChanged()),
            this, TQ_SLOT(slSpellConfigChanged()));
}

void KOCRBase::slSpellConfigChanged()
{
    kdDebug(28000) << "Spellcheck config changed" << endl;
}



void KOCRBase::stopAnimation()
{
   if( m_animation )
      m_animation->stop();
}

void KOCRBase::startAnimation()
{
   if( m_animation )
      m_animation->start();
}

KOCRBase::~KOCRBase()
{

}

void KOCRBase::introduceImage( KookaImage* img)
{
    if( ! (img && img->isFileBound()) ) return;
    KFileMetaInfo info = img->fileMetaInfo();
    TQStringList groups;
    if ( info.isValid() )
         groups = info.preferredGroups();

    delete m_metaBox;
    m_metaBox = new TQVBox( m_imgHBox );

    /* Start to create a preview job for the thumb */
    KURL::List li(img->url());
    TDEIO::Job *m_job = TDEIO::filePreview(li, m_previewSize.width(),
                                       m_previewSize.height());

    if( m_job )
    {
        connect( m_job, TQ_SIGNAL( result( TDEIO::Job * )),
                 this, TQ_SLOT( slPreviewResult( TDEIO::Job * )));
        connect( m_job, TQ_SIGNAL( gotPreview( const KFileItem*, const TQPixmap& )),
                 TQ_SLOT( slGotPreview( const KFileItem*, const TQPixmap& ) ));
         /* TDEIO::Jo result is called in any way: Success, Failed, Error,
          * thus connecting the failed is not really necessary.
          */
    }

    for ( TQStringList::Iterator it = groups.begin(); it != groups.end(); ++it )
    {
        TQString theGroup(*it);

        kdDebug(29000) << "handling the group " << theGroup << endl;

        TQStringList keys = info.group(theGroup).supportedKeys();

        if( keys.count() > 0 )
        {
            // info.groupInfo( theGroup )->translatedName()
            // FIXME: howto get the translated group name?
            TQLabel *lGroup = new TQLabel( theGroup, m_metaBox );
            lGroup->setBackgroundColor( TQColor(gray));
            lGroup->setMargin( KDialog::spacingHint());

            TQGrid *nGrid = new TQGrid( 2,  m_metaBox );
            nGrid->setSpacing( KDialog::spacingHint());
            for ( TQStringList::Iterator keyIt = keys.begin(); keyIt != keys.end(); ++keyIt )
            {
                KFileMetaInfoItem item = info.item(*keyIt);
                TQString itKey = item.translatedKey();
                if( itKey.isEmpty() )
                    itKey = item.key();
                if( ! itKey.isEmpty() )
                {
                    (void) new TQLabel( item.translatedKey() + ": ", nGrid );
                    (void) new TQLabel( item.string(), nGrid );
                    kdDebug(29000) << "hasKey " << *keyIt << endl;
                }
            }
        }
    }
    TQWidget *spaceEater = new TQWidget( m_metaBox );
    spaceEater->setSizePolicy( TQSizePolicy( TQSizePolicy::Ignored, TQSizePolicy::Ignored ));
    m_metaBox->show();
}

void KOCRBase::slPreviewResult(TDEIO::Job *job )
{
    // nothing
    if( job && job->error() > 0 )
   {
      kdDebug(28000) << "Thumbnail Creation ERROR: " << job->errorString() << endl;
      job->showErrorDialog( 0 );
   }
}

void KOCRBase::slGotPreview( const KFileItem*, const TQPixmap& newPix )
{
    kdDebug(28000) << "Got the preview" << endl;
    m_previewPix->setPixmap(newPix);

    if( m_previewPix && m_currImg )
    {
        m_previewPix->setPixmap(newPix);
    }
}


void KOCRBase::writeConfig()
{

}

bool KOCRBase::wantSpellCheck()
{
    return m_userWantsSpellCheck;
}

void KOCRBase::startOCR()
{
    /* en- and disable the buttons */
    kdDebug(28000) << "Base: Starting OCR" << endl;

    enableFields(false);
    enableButton( User1, false );   /* Start OCR */
    enableButton( User2, true );    /* Stop OCR */
    enableButton( Close, true );

    startAnimation();
}

void KOCRBase::stopOCR()
{
    enableFields(true);

    enableButton( User1, true );   /* start ocr */
    enableButton( User2, false );  /* Cancel    */
    enableButton( Close, true );

    stopAnimation();

}

void KOCRBase::enableFields(bool)
{

}

void KOCRBase::slWantSpellcheck( bool wantIt )
{
    if( m_gbSpellOpts )
    {
        m_gbSpellOpts->setEnabled( wantIt );
    }
    m_userWantsSpellCheck = wantIt;

    TDEConfig *konf = TDEGlobal::config ();
    TDEConfigGroupSaver gs( konf, CFG_OCR_TDESPELL );
    konf->writeEntry( CFG_WANT_TDESPELL, wantIt );
}

/* The End ;) */
#include "kocrbase.moc"
