/*
    This file is part of tdepim.

    Copyright (C) 2004 Reinhold Kainhofer <reinhold@kainhofer.com>


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "exchangeaddressbookadaptor.h"

#include "tdeabc_resourceexchange.h"
#include "groupwaredownloadjob.h"
#include "groupwareuploadjob.h"
#include "tderesources_groupwareprefs.h"

#include <tdelocale.h>

using namespace TDEABC;

ResourceExchange::ResourceExchange( const TDEConfig *config )
  : ResourceGroupwareBase( config )
{
  init();
  if ( config ) {
    readConfig( config );
  } else {
    setResourceName( i18n( "Exchange Server" ) );
  }
}

void ResourceExchange::init()
{
  setType( "ResourceExchange" );
  setPrefs( createPrefs() );
  setFolderLister( new KPIM::FolderLister( KPIM::FolderLister::AddressBook ) );
  setAdaptor( new ExchangeAddressBookAdaptor() );
  
  ResourceGroupwareBase::init();
}

#include "tdeabc_resourceexchange.moc"
