/*
 Kopete Oscar Protocol
 userinfotask.h - Handle sending and receiving info requests for users

 Copyright (c) 2004-2005 Matt Rogers <mattr@kde.org>

 Kopete (c) 2002-2005 by the Kopete developers <kopete-devel@kde.org>

 *************************************************************************
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of the GNU Lesser General Public            *
 * License as published by the Free Software Foundation; either          *
 * version 2 of the License, or (at your option) any later version.      *
 *                                                                       *
 *************************************************************************
*/
#ifndef USERINFOTASK_H
#define USERINFOTASK_H

#include "task.h"

#include <tqstring.h>
#include "userdetails.h"

class Transfer;

/**
Handles user information requests that are done via SNAC 02,05 and 02,06
 
@author Kopete Developers
*/
class UserInfoTask : public Task
{
TQ_OBJECT
  
public:
	UserInfoTask( Task* parent );
	~UserInfoTask();
	
	enum { Profile = 0x0001, General = 0x0002, AwayMessage = 0x0003, Capabilities = 0x0004 };

	//! Task implementation
	bool forMe( const Transfer* transfer ) const;
	bool take( Transfer* transfer );
	void onGo();
	
	void requestInfoFor( const TQString& userId, unsigned int types );
	UserDetails getInfoFor( TQ_UINT16 sequence ) const;
	TQString contactForSequence( TQ_UINT16 sequence ) const;
	
	
signals:
	void gotInfo( TQ_UINT16 seqNumber );
	void receivedProfile( const TQString& contact, const TQString& profile );
	void receivedAwayMessage( const TQString& contact, const TQString& message );
	
private:
	TQMap<TQ_UINT16, UserDetails> m_sequenceInfoMap;
	TQMap<TQ_UINT16, TQString> m_contactSequenceMap;
	TQMap<TQ_UINT16, unsigned int> m_typesSequenceMap;
	TQ_UINT16 m_seq;
	
};



#endif
