/***************************************************************************
                    dcopwindowmanagerif.h  -  description
                             -------------------
    begin                : Wed Feb 5 2003
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPWINDOWMANAGERIF_H
#define DCOPWINDOWMANAGERIF_H

#include <dcopobject.h>
#include <tqstringlist.h>

class DCOPWindowManagerIf : virtual public DCOPObject
{
  K_DCOP

  k_dcop:

  virtual int currentEditorIfNum() const = 0;
  virtual TQString currentURL() const = 0;
  virtual TQString projectURL() const = 0;
  virtual TQStringList openedURLs() const = 0;
  virtual TQStringList tagAreas(const TQString& tag, bool includeCoordinates, bool skipFoundContent) const = 0;
  virtual void newCursorPosition(const TQString &file, int lineNumber, int columnNumber) = 0;
  virtual void newDebuggerPosition(const TQString &file, int lineNumber) = 0;
  virtual void openFile(const TQString &file, int lineNumber, int columnNumber) = 0;
  virtual TQString saveCurrentFile() = 0;
  virtual void setDtep(const TQString& dtepName, bool convert) = 0;
  virtual TQString documentFolderForURL(const TQString &url) = 0;
  virtual TQString urlWithPreviewPrefix(const TQString &url) = 0;
  virtual void addFileToProject(const TQString &url) = 0;
  virtual void addFolderToProject(const TQString &url) = 0;
  virtual void uploadURL(const TQString &url, const TQString& profile, bool markOnly) = 0;
};

#endif

