// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

#ifndef ATLANTIK_ESTATEDETAILS_H
#define ATLANTIK_ESTATEDETAILS_H

#include <tqwidget.h>

class TQPixmap;
class TQString;
class TQHBoxLayout;
class TQVBoxLayout;
class TQVGroupBox;

class TDEListView;
class KPixmap;
class KPushButton;

class Player;
class Estate;

class EstateDetails : public TQWidget
{
  TQ_OBJECT
  

public:
	EstateDetails(Estate *estate, TQString text, TQWidget *parent, const char *name = 0);
	~EstateDetails();
	Estate *estate() { return m_estate; }

	void addDetails();
	void addButton(const TQString command, const TQString caption, bool enabled);
	void addCloseButton();
	void setEstate(Estate *estate);
	void setText(TQString text);
	void appendText(TQString text);
	void clearButtons();

protected:
	void paintEvent(TQPaintEvent *);
	void resizeEvent(TQResizeEvent *);

private slots:
	void buttonPressed();

signals:
	void buttonCommand(TQString);
	void buttonClose();

private:
	Estate *m_estate;
	TQPixmap *m_pixmap;
	KPixmap *m_quartzBlocks;
	TDEListView *m_infoListView;
	KPushButton *m_closeButton;
	bool b_recreate, m_recreateQuartz;
	TQVBoxLayout *m_mainLayout;
	TQHBoxLayout *m_buttonBox;
	TQVGroupBox *m_textGroupBox;
	TQMap <TQObject *, TQString> m_buttonCommandMap;
	TQPtrList<KPushButton> m_buttons;
};

#endif
