/***************************************************************************
 *   Copyright (C) 2006 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef ARCHIVE_H
#define ARCHIVE_H

#include <tqvaluelist.h>
#include <tqmap.h>

class Basket;
class Tag;

class TQString;
class TQStringList;
class TQDomNode;
class KTar;
class KProgress;

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class Archive
{
  public:
	static void save(Basket *basket, bool withSubBaskets, const TQString &destination);
	static void open(const TQString &path);
  private:
	// Convenient Methods for Saving:
	static void saveBasketToArchive(Basket *basket, bool recursive, KTar *tar, TQStringList &backgrounds, const TQString &tempFolder, KProgress *progress);
	static void listUsedTags(Basket *basket, bool recursive, TQValueList<Tag*> &list);
	// Convenient Methods for Loading:
	static void renameBasketFolders(const TQString &extractionFolder, TQMap<TQString, TQString> &mergedStates);
	static void renameBasketFolder(const TQString &extractionFolder, TQDomNode &basketNode, TQMap<TQString, TQString> &folderMap, TQMap<TQString, TQString> &mergedStates);
	static void renameMergedStatesAndBasketIcon(const TQString &fullPath, TQMap<TQString, TQString> &mergedStates, const TQString &extractionFolder);
	static void renameMergedStates(TQDomNode notes, TQMap<TQString, TQString> &mergedStates);
	static void importBasketIcon(TQDomElement properties, const TQString &extractionFolder);
	static void loadExtractedBaskets(const TQString &extractionFolder, TQDomNode &basketNode, TQMap<TQString, TQString> &folderMap, Basket *parent);
	static void importTagEmblems(const TQString &extractionFolder);
	static void importArchivedBackgroundImages(const TQString &extractionFolder);
};

#endif
