/***************************************************************************
                          kcsvprogressdlg.cpp  -  description
                             -------------------
    begin                : Sun Jul 29 2001
    copyright            : (C) 2000-2001 by Michael Edwardes
    email                : mte@users.sourceforge.net
                             Javier Campos Morales <javi_c@users.sourceforge.net>
                             Felix Rodriguez <frodriguez@users.sourceforge.net>
                             John C <thetacoturtle@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kstandarddirs.h>

#include <tqpixmap.h>
// ----------------------------------------------------------------------------
// TQt Includes
#include <tqfile.h>
#include <tqtextstream.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqprogressbar.h>
#include <tqlineedit.h>
#include <tqgroupbox.h>

// ----------------------------------------------------------------------------
// TDE Includes
#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeconfig.h>

// ----------------------------------------------------------------------------
// Project Includes
#include "kcsvprogressdlg.h"
#include "../widgets/kmymoneydateinput.h"
#include "../kmymoneyutils.h"

/** Simple constructor */
KCsvProgressDlg::KCsvProgressDlg(int type, MyMoneyAccount *account, TQWidget *parent, const char *name )
 : KCsvProgressDlgDecl(parent,name, true)
{
  m_nType = type;
  if (m_nType==0)
  {
    m_kmymoneydateEnd->setEnabled(false);
    m_kmymoneydateStart->setEnabled(false);
    m_qbuttonRun->setText(i18n("&Import"));
  }
  else
    m_qbuttonRun->setText(i18n("&Export"));

  m_mymoneyaccount = account;

  m_qbuttonOk->setText(i18n("C&lose"));

  readConfig();

  connect(m_qbuttonBrowse, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotBrowseClicked()));
  connect(m_qbuttonRun, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotRunClicked()));
  connect(m_qlineeditFile, TQ_SIGNAL(textChanged(const TQString&)), this,
    TQ_SLOT(slotFileTextChanged(const TQString&)));
  connect(m_qbuttonOk, TQ_SIGNAL(clicked()), this, TQ_SLOT(accept()));
}

/** Simple destructor */
KCsvProgressDlg::~KCsvProgressDlg()
{
  writeConfig();
}

/** Perform the export process */
void KCsvProgressDlg::performExport(void)
{
/*
  // Do some validation on the inputs.
  if (m_qlineeditFile->text().isEmpty()) {
    KMessageBox::information(this, i18n("Please enter the path to the CSV file"), i18n("Export CSV"));
    m_qlineeditFile->setFocus();
    return;
  }

  TQString strFile = m_qlineeditFile->text();
  if(KMyMoneyUtils::appendCorrectFileExt(strFile, TQString("csv")))
    m_qlineeditFile->setText(strFile);

  if (m_kmymoneydateEnd->getTQDate() < m_kmymoneydateStart->getTQDate()) {
    KMessageBox::information(this, i18n("Please enter a start date lower than the end date."));
    return;
  }

  TQFile qfile(m_qlineeditFile->text());
  if (!qfile.open(IO_WriteOnly)) {
    KMessageBox::error(this, i18n("Unable to open export file for writing."));
    return;
  }
  qfile.close();

  m_qlabelAccount->setText(m_mymoneyaccount->name());
  m_qlabelTransaction->setText(TQString("0") + i18n(" of ") + TQString::number(m_mymoneyaccount->transactionCount()));
  m_qprogressbar->setTotalSteps(m_mymoneyaccount->transactionCount());

  // Make sure we have an account to operate on
  if (m_mymoneyaccount) {
    // Connect to the provided signals in MyMoneyAccount
    // These signals will be emitted at appropriate times.
    connect(m_mymoneyaccount, TQ_SIGNAL(signalProgressCount(int)), m_qprogressbar, TQ_SLOT(setTotalSteps(int)));
    connect(m_mymoneyaccount, TQ_SIGNAL(signalProgress(int)), this, TQ_SLOT(slotSetProgress(int)));

    int nTransCount = 0;

    // Do the actual write
    if (!m_mymoneyaccount->writeCSVFile(m_qlineeditFile->text(), m_kmymoneydateStart->getTQDate(),
          m_kmymoneydateEnd->getTQDate(), nTransCount)) {
      KMessageBox::error(this, i18n("Error occurred whilst exporting to csv file."), i18n("Export CSV"));
    }
    else {
      TQString qstringPrompt = i18n("Export finished successfully.\n\n");
      qstringPrompt += i18n("Number of transactions exported ");
      qstringPrompt += TQString::number(nTransCount);
      qstringPrompt += ".";
      KMessageBox::information(this, qstringPrompt, i18n("Export CSV"));
    }
  }
*/
}

/** perform the import process */
void KCsvProgressDlg::performImport(void)
{
/*
  // Do some validation on the inputs.
  if (m_qlineeditFile->text().isEmpty()) {
    KMessageBox::information(this, i18n("Please enter the path to the CSV file"), i18n("Import CSV"));
    m_qlineeditFile->setFocus();
    return;
  }

  TQFile qfile(m_qlineeditFile->text());
  if (!qfile.open(IO_ReadOnly)) {
    KMessageBox::error(this, i18n("Unable to open import file for reading."));
    return;
  }
  qfile.close();

  m_qlabelAccount->setText(m_mymoneyaccount->name());

  // Make sure we have an account to operate on
  if (m_mymoneyaccount) {
    // Connect to the provided signals in MyMoneyAccount
    // These signals will be emitted at appropriate times.
    connect(m_mymoneyaccount, TQ_SIGNAL(signalProgressCount(int)), m_qprogressbar, TQ_SLOT(setTotalSteps(int)));
    connect(m_mymoneyaccount, TQ_SIGNAL(signalProgress(int)), this, TQ_SLOT(slotSetProgress(int)));

    int nTransCount = 0;

    // Do the actual write
    if (!m_mymoneyaccount->readCSVFile(m_qlineeditFile->text(), nTransCount)) {
      KMessageBox::error(this, i18n("Error occurred whilst importing csv file."), i18n("Import CSV"));
    }
    else {
      TQString qstringPrompt = i18n("Import finished successfully.\n\n");
      qstringPrompt += i18n("Number of transactions imported ");
      qstringPrompt += TQString::number(nTransCount);
      qstringPrompt += ".";
      KMessageBox::information(this, qstringPrompt, i18n("Import CSV"));
    }
  }
*/
}

/** Called when the user clicks on the Browser button */
void KCsvProgressDlg::slotBrowseClicked()
{
  TQString newName = KFileDialog::getSaveFileName(TQString(),"*.CSV");
  if (!newName.isEmpty())
  {
    m_qlineeditFile->setText(newName);
    m_qbuttonRun->setEnabled(true);
  }
  else
    m_qbuttonRun->setEnabled(false);
}

/** Called when user clicks on the Run button */
void KCsvProgressDlg::slotRunClicked()
{
  m_qgroupbox->setEnabled(true);
  if (m_nType==0)
    performImport();
  else
    performExport();
}

/** Make sure the text input is ok */
void KCsvProgressDlg::slotFileTextChanged(const TQString& text)
{
  if (!text.isEmpty()) {
    m_qlineeditFile->setText(text);
    m_qbuttonRun->setEnabled(true);
  } else
    m_qbuttonRun->setEnabled(false);
}

void KCsvProgressDlg::readConfig(void)
{
  TDEConfig *tdeconfig = TDEGlobal::config();
  tdeconfig->setGroup("Last Use Settings");
  m_kmymoneydateStart->setDate(tdeconfig->readDateTimeEntry("KCsvProgressDlg_StartDate").date());
  m_kmymoneydateEnd->setDate(tdeconfig->readDateTimeEntry("KCsvProgressDlg_EndDate").date());
  m_qlineeditFile->setText(tdeconfig->readEntry("KCsvProgressDlg_LastFile", ""));
  if (m_qlineeditFile->text().length()>=1)
    m_qbuttonRun->setEnabled(true);
  else
    m_qbuttonRun->setEnabled(false);
}

void KCsvProgressDlg::writeConfig(void)
{
  TDEConfig *tdeconfig = TDEGlobal::config();
  tdeconfig->setGroup("Last Use Settings");
  tdeconfig->writeEntry("KCsvProgressDlg_LastFile", m_qlineeditFile->text());
  tdeconfig->writeEntry("KCsvProgressDlg_StartDate", TQDateTime(m_kmymoneydateStart->date()));
  tdeconfig->writeEntry("KCsvProgressDlg_EndDate", TQDateTime(m_kmymoneydateEnd->date()));
  tdeconfig->sync();
}

/** Update the progress bar, and update the transaction count indicator. */
void KCsvProgressDlg::slotSetProgress(int progress)
{
  m_qprogressbar->setProgress(progress);
  TQString qstring = TQString::number(progress);
  qstring += i18n(" of ");
  qstring += TQString::number(m_qprogressbar->totalSteps());
  m_qlabelTransaction->setText(qstring);
}

#include "kcsvprogressdlg.moc"
