#!/bin/bash

# $1 == C++ compiler
# $2 == output name

echo "class QApplication { public: int exec(); }; int QApplication::exec() { return 0; } " \
     "class QDialog { public: int exec(); }; int QDialog::exec() { return 0; }" >> "$2.cpp"

$1 -c "$2.cpp" -o "$2.o"
qdialog=`nm "$2.o" | grep QDialog | grep exec | awk '{print $3}'`
qapplication=`nm "$2.o" | grep QApplication | grep exec | awk '{print $3}'`
rm "$2.o" "$2.cpp"

echo "#ifndef __KGTK_MANGLED_H__" > "$2"
echo "#define __KGTK_MANGLED_H__" >> "$2"
echo "#define KQT_QDIALOG_EXEC \"$qdialog\"" >> "$2"
echo "#define KQT_QAPPLICATION_EXEC \"$qapplication\"" >> "$2"
echo "#endif" >> "$2"





