/* This file is part of the KDE project
   Copyright (C) 2002 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef koDirectoryStore_h
#define koDirectoryStore_h

#include "KoStoreBase.h"

class TQFile;

class KoDirectoryStore : public KoStoreBase
{
public:
    KoDirectoryStore( const TQString& path, Mode _mode );
    ~KoDirectoryStore();
protected:
    virtual bool init( Mode _mode );
    virtual bool openWrite( const TQString& name ) { return openReadOrWrite( name, IO_WriteOnly ); }
    virtual bool openRead( const TQString& name ) { return openReadOrWrite( name, IO_ReadOnly ); }
    virtual bool closeRead() { return true; }
    virtual bool closeWrite() { return true; }
    virtual bool enterRelativeDirectory( const TQString& dirName );
    virtual bool enterAbsoluteDirectory( const TQString& path );
    virtual bool fileExists( const TQString& absPath ) const;

    bool openReadOrWrite( const TQString& name, int iomode );
private:
    // Path to base directory (== the ctor argument)
    TQString m_basePath;

    // Path to current directory
    TQString m_currentPath;

    // Current File
    TQFile* m_file;
};

#endif
