/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) version 2.
*/

/*
  Copyright (C) 2008 Eli J. MacKenzie <argonel at gmail.com>
*/


#ifndef QUEUETUNER_H
#define QUEUETUNER_H

#include "queuetunerbase.h"

class Server;
class ViewContainer;
class TQTimer;

#include <tqtimer.h>

class QueueTuner: public QueueTunerBase
{
    TQ_OBJECT
  

    public:
        QueueTuner(TQWidget* parent, ViewContainer *container);
        ~QueueTuner();
        virtual void contextMenuEvent (TQContextMenuEvent*);

    public slots:
        void setServer(Server* newServer);
        void getRates();
        void timerFired();
        virtual void hide();
        virtual void show();
        virtual void open();
        virtual void close();
        void slowRateChanged(int);
        void slowTypeChanged(int);
        void slowIntervalChanged(int);
        void normalRateChanged(int);
        void normalTypeChanged(int);
        void normalIntervalChanged(int);
        void fastRateChanged(int);
        void fastTypeChanged(int);
        void fastIntervalChanged(int);
        void serverDestroyed(TQObject*);

    signals:
        void hidden();

    private:
        Server* m_server;
        TQTimer m_timer;
        bool &m_vis;
};


#endif
