//
// C++ Implementation: mallorybutton
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <tqtooltip.h>
#include <tqpainter.h>
#include <tqpixmap.h>

#include "enums.h"
#include "mallorybutton.h"
#include "malloryhandler.h"
#include "pixmaps.h"

#include "embeddata.h"

MalloryButton::MalloryButton(MalloryClient *parent, const char *name, const TQString& tip, ButtonType type) : TQButton(parent->widget(), name), m_client(parent), m_lastMouse(0), m_type(type), hover(false), isOnAllDesktops(false), isMaximized(false)
{
	TQToolTip::add(this, tip);
	setCursor(arrowCursor);
	setBackgroundMode(NoBackground);
	setFixedSize(MalloryHandler::buttonSize(), MalloryHandler::buttonSize());
}


MalloryButton::~MalloryButton()
{
}

void MalloryButton::setTipText(const TQString &tip)
{
	TQToolTip::remove(this);
	TQToolTip::add(this, tip);
}

TQSize MalloryButton::sizeHint() const // MXLS
{
	return TQSize(MalloryHandler::buttonSize(), MalloryHandler::buttonSize());
}

void MalloryButton::enterEvent(TQEvent *e)
{
	hover = true;
	repaint(false);
	TQButton::enterEvent(e);
}

void MalloryButton::leaveEvent(TQEvent *e)
{
	hover = false;
	repaint(false);
	TQButton::enterEvent(e);
}

void MalloryButton::mousePressEvent(TQMouseEvent *e)
{
	m_lastMouse = e->button();
	TQMouseEvent me(e->type(), e->pos(), e->globalPos(), LeftButton, e->state());
	TQButton::mousePressEvent(&me);
}

void MalloryButton::mouseReleaseEvent(TQMouseEvent *e)
{
	m_lastMouse = e->button();
	TQMouseEvent me(e->type(), e->pos(), e->globalPos(), LeftButton, e->state());
	TQButton::mouseReleaseEvent(&me);
}

void MalloryButton::drawButton(TQPainter *painter)
{
	if (!MalloryHandler::initialized())
		return;

	bool active = m_client->isActive();
	int buttonSize = MalloryHandler::buttonSize();

	int ofx = (buttonSize-16)/2;
	int ofy = ofx;

	// Crush the bug the hard way!
	if (ofy < 2)
		ofy = 2;

	TQPixmap pufferPixmap;
	pufferPixmap.resize(buttonSize, buttonSize);

	TQPainter pufferPainter(&pufferPixmap);
	pufferPainter.drawPixmap(0, 0, active ? *Pixmaps::active_button_ground : *Pixmaps::inactive_button_ground);

	if (m_type == ButtonMenu)
	{
		TQPixmap menu_icon = m_client->icon().pixmap(TQIconSet::Small, TQIconSet::Normal);
		pufferPainter.drawPixmap(ofx, ofy, menu_icon);
	}
	else
	{
		// Paint the little icon on the buttons.
		// Lotsa trouble with this! Stupid scope!

		if (hover && !isDown())
		{
			// Hover
			if (m_type == ButtonHelp)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_help_hover : *Pixmaps::inactive_help_hover);
			else if (m_type == ButtonMax)
			{
				if (isMaximized)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_restore_hover : *Pixmaps::inactive_restore_hover);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_max_hover : *Pixmaps::inactive_max_hover);
			}
			else if (m_type == ButtonMin)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_min_hover : *Pixmaps::inactive_min_hover);
			else if (m_type == ButtonClose)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_close_hover : *Pixmaps::inactive_close_hover);
			else if (m_type == ButtonOnAllDesktops)
			{
				if (isOnAllDesktops)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_unsticky_hover : *Pixmaps::inactive_unsticky_hover);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_sticky_hover : *Pixmaps::inactive_sticky_hover);
			}
			else if (m_type == ButtonAbove)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_above_hover : *Pixmaps::inactive_above_hover);
			else if (m_type == ButtonBelow)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_below_hover : *Pixmaps::inactive_below_hover);
		}
		else if (isDown())
		{
			// Sunken
			if (m_type == ButtonHelp)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_help_sunken : *Pixmaps::inactive_help_sunken);
			else if (m_type == ButtonMax)
			{
				if (isMaximized)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_restore_sunken : *Pixmaps::inactive_restore_sunken);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_max_sunken : *Pixmaps::inactive_max_sunken);
			}
			else if (m_type == ButtonMin)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_min_sunken : *Pixmaps::inactive_min_sunken);
			else if (m_type == ButtonClose)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_close_sunken : *Pixmaps::inactive_close_sunken);
			else if (m_type == ButtonOnAllDesktops)
			{
				if (isOnAllDesktops)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_unsticky_sunken : *Pixmaps::inactive_unsticky_sunken);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_sticky_sunken : *Pixmaps::inactive_sticky_sunken);
			}
			else if (m_type == ButtonAbove)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_above_sunken : *Pixmaps::inactive_above_sunken);
			else if (m_type == ButtonBelow)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_below_sunken : *Pixmaps::inactive_below_sunken);
		}
		else
		{
			// Normal
			if (m_type == ButtonHelp)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_help_normal : *Pixmaps::inactive_help_normal);
			else if (m_type == ButtonMax)
			{
				if (isMaximized)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_restore_normal : *Pixmaps::inactive_restore_normal);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_max_normal : *Pixmaps::inactive_max_normal);
			}
			else if (m_type == ButtonMin)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_min_normal : *Pixmaps::inactive_min_normal);
			else if (m_type == ButtonClose)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_close_normal : *Pixmaps::inactive_close_normal);
			else if (m_type == ButtonOnAllDesktops)
			{
				if (isOnAllDesktops)
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_unsticky_normal : *Pixmaps::inactive_unsticky_normal);
				else
					pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_sticky_normal : *Pixmaps::inactive_sticky_normal);
			}
			else if (m_type == ButtonAbove)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_above_normal : *Pixmaps::inactive_above_normal);
			else if (m_type == ButtonBelow)
				pufferPainter.drawImage(ofx, ofy, active ? *Pixmaps::active_below_normal : *Pixmaps::inactive_below_normal);
		}
	}
	pufferPainter.end();
	painter->drawPixmap(0, 0, pufferPixmap);
}
#include "mallorybutton.moc"
