/*  Ia Ora
 *  Copyright (C) 2003 Frederic Crozat - Mandriva
 *                1999 Olivier Fourdan (fourdan@xfce.org) for XFCE code
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtkstyle.h>

typedef struct _Ia_OraStyle Ia_OraStyle;
typedef struct _Ia_OraStyleClass Ia_OraStyleClass;

__attribute__((__visibility__("internal"))) extern GType ia_ora_type_style;

#define IA_ORA_TYPE_STYLE              ia_ora_type_style
#define IA_ORA_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), IA_ORA_TYPE_STYLE, Ia_OraStyle))
#define IA_ORA_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), IA_ORA_TYPE_STYLE, Ia_OraStyleClass))
#define IA_ORA_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), IA_ORA_TYPE_STYLE))
#define IA_ORA_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), IA_ORA_TYPE_STYLE))
#define IA_ORA_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), IA_ORA_TYPE_STYLE, Ia_OraStyleClass))

#define N_BLUE_COLORS 5
#define N_GRAY_COLORS 7

struct _Ia_OraStyle
{
  GtkStyle parent_instance;
  GdkColor gray[N_GRAY_COLORS]; /* from light to dark */
  GdkColor blue[N_BLUE_COLORS]; /* from light to dark */
  GdkColor check_color;
  
  GdkGC *gray_gc[N_GRAY_COLORS]; /* from light to dark */
  GdkGC *blue_gc[N_BLUE_COLORS]; /* from light to dark */

  GdkGC *check_gc;

  GdkPixmap *radio_pixmap_circle[5];
  GdkBitmap *radio_pixmap_mask; /* All masks are the same */

};

struct _Ia_OraStyleClass
{
    GtkStyleClass parent_class;
};

__attribute__((__visibility__("internal"))) void ia_ora_style_register_type(GTypeModule * module);
