#include "colorpicker.h"
#include <tqcolor.h>
#include <tqlayout.h>
#include <knuminput.h>

ColorPicker::ColorPicker(TQWidget* parent, const char* name) : TQGroupBox( parent, name)
{
   setTitle(name);
   setColumnLayout(0, TQt::Vertical );
   layout()->setSpacing( 6 );
   layout()->setMargin( 11 );
    
   TQVBoxLayout *vLayout = new TQVBoxLayout(layout());
    
   red = new KIntNumInput(this, "red");
   red->setRange(0, 255, 1, true);
   red->setLabel("R");
   vLayout->addWidget(red);
   green = new KIntNumInput(this, "green");
   green->setRange(0, 255, 1, true);
   green->setLabel("G");
   vLayout->addWidget(green);
   blue = new KIntNumInput(this, "blue");
   blue->setRange(0, 255, 1, true);
   blue->setLabel("B");
   vLayout->addWidget(blue);
   connect (red, TQ_SIGNAL(valueChanged( int )), this, TQ_SLOT(emitChange()));
   connect (green, TQ_SIGNAL(valueChanged( int )), this, TQ_SLOT(emitChange()));
   connect (blue, TQ_SIGNAL(valueChanged( int )), this, TQ_SLOT(emitChange()));
}

ColorPicker::~ColorPicker()
{
}

void ColorPicker::emitChange()
{
   emit colorChanged(TQColor(red->value(), green->value(), blue->value()));
}

void ColorPicker::setColor(const TQColor & color)
{
    red->setValue( color.red() );
    green->setValue( color.green() );
    blue->setValue( color.blue() );
    emit colorChanged(color);
}

void ColorPicker::setRed(int r)
{
    red->setValue( r );
    emit colorChanged(TQColor(r, green->value(), blue->value()));
}

void ColorPicker::setGreen(int g)
{
    green->setValue( g );
    emit colorChanged(TQColor(red->value(), g, blue->value()));
}

void ColorPicker::setBlue(int b)
{
    blue->setValue( b );
    emit colorChanged(TQColor(red->value(), green->value(), b));
}

TQColor & ColorPicker::color()
{
   color__ = TQColor(red->value(), green->value(), blue->value());
   return color__;
}

void ColorPicker::reset()
{
    setColor(color_);
}

void ColorPicker::init()
{
    color_ = color();
}

#include "colorpicker.moc"
