/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lübking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _TDESTYLE_BAGHIRA_CONFIG_H_
#define _TDESTYLE_BAGHIRA_CONFIG_H_

//#include <tdecmodule.h>
#include <tqcolor.h>
#include <tqimage.h>
#include <tdeaboutdata.h>
#include "configdialog.h"
#include "help.h"
#include "about.h"

class TDEListView;
class TQPushButton;
class AppSetter;
class TQTimer;
class TQCheckBox;
class TQComboBox;
class TQGroupBox;

class tdestyle_baghira_config: public TQWidget
{
   TQ_OBJECT

public:
   tdestyle_baghira_config( TQWidget *parent=0, const char *name=0, const TQStringList& = TQStringList() );
   ~tdestyle_baghira_config();

   virtual void load();
   void load(TQString &fileName);
   void save(TQString &fileName);
//    virtual int buttons();
   virtual TQString quickHelp() const;
   virtual const TDEAboutData *aboutData()const
   { return myAboutData; };

public slots:
   void configChanged();
   void openHtml1();
   void openHtml2();
   void startBab();
   void startKRuler();
   void sliderButtonRedChanged(int);
   void sliderButtonGreenChanged(int);
   void sliderButtonBlueChanged(int);
   void sliderBrushRedChanged(int);
   void sliderBrushGreenChanged(int);
   void sliderBrushBlueChanged(int);
   virtual void save();
   virtual void defaults();

signals:
   void changed(bool);
   void editApp(TQString, TQString);

protected:
   bool eventFilter( TQObject* o, TQEvent* e );

private:
   TQString crNotes[3];
   AppSetter *appsetter;
   TDEListView *applist;
   TQImage* tintButton(TQImage &src, TQColor c);
   TQImage* tintBrush( TQImage &img, TQColor c/*, int saturation*/ );
   WId findWindow();
   TDEAboutData *myAboutData;
   Config *dialog_;
   Help* help_;
   About* about_;
   TQImage baseImage, baseImage2;
   TQDialog *grabber;
   TQColor buttonColor;
   TQColor brushTint;
   int sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue;
   int sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/;
   bool loadDone;
   bool menuReplaced;
   TQTimer *timer;
   int crCurrent;
private slots:
   void updateCR();
   void showAbout();
   void editApp();
   void addApp(TQString, TQString);
   void removeApp();
   void removeApp(TQString);
   void setDesign(int);
   void menuToggled(bool);
   void enableInButtonColor(int d);
   void enableMenuColorStuff(int d);
   void buttonLoadAction();
   void buttonSaveAsAction();
   void setPresetColor(int i);
   void selectWindow();
   void changeTooluttonHighlightColor(const TQColor &);
   void handleButtonStyles(int i);
};

class ColorDialog;

class AppSetter : public TQWidget
{
TQ_OBJECT
public:
   AppSetter(TQWidget *parent=0, const char *name=0);
   ~AppSetter();
public slots:
   void show();
   void show(TQString appName, TQString link);

private:
   bool isEdit;
   int index_;
   int colors[8];
   TQString oldName;
   TQString oldLink;
   TQLineEdit *command;
   TQComboBox *link;
   TQGroupBox *box;
   TQComboBox *style;
   TQComboBox *deco;
   TQComboBox *buttons;
   TQComboBox *toolButtons;
   TQComboBox *tabs;
   TQComboBox *inbutton;
   TQCheckBox *scanlines;
   TQCheckBox *customColors;
   TQPushButton *buttonColors;
   ColorDialog *colorDialog;

signals:
   void addApp(TQString, TQString);
   void removeApp(TQString);

private slots:
   void save();
   void reset();
   void handler(int);
   void updateColors();
   void resetColorPicker();
   void handleButtonStyles(int i);
};

#endif
