
#include "ripperpluginloader.h"

#include <tqfile.h>

#include <tdelocale.h>


RipperPlugin::RipperPlugin()
{}

RipperPlugin::~RipperPlugin()
{}


RipperPluginLoader::RipperPluginLoader()
{}

RipperPluginLoader::~RipperPluginLoader()
{}

int RipperPluginLoader::verifyFile( TQString fileName )
{
    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return -1;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return -1;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "ripper" ) return -1;
    int version;
    TQDomNode node;
    node = root.firstChild();
    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {
            version = node.toElement().attribute("version","0").toInt();
            break;
        }
    }

    return version;
}

RipperPlugin* RipperPluginLoader::loadFile( TQString fileName )
{
    int t_int;
    float t_float;
    TQString t_str;

    RipperPlugin* plugin = new RipperPlugin();
    plugin->info.version = -1; // if something goes wrong, we can see that by looking at plugin->info.version
    plugin->filePathName = fileName;

    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return plugin;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return plugin;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "ripper" ) return plugin;
    TQDomNode node, sub1Node;
    node = root.firstChild();

    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "info" ) {

            plugin->info.name = node.toElement().attribute("name",i18n("Unknown Name"));
            plugin->info.about = node.toElement().attribute("about",i18n("Sorry, no information available!"));
            plugin->info.author = node.toElement().attribute("author",i18n("Unknown Author"));
            plugin->info.version = node.toElement().attribute("version","0").toInt();

        }
        else if( node.isElement() && node.nodeName() == "rip" ) {

            plugin->rip.rank = node.toElement().attribute("rank","10").toInt();
            plugin->rip.bin = node.toElement().attribute( "bin" );
            plugin->rip.param = node.toElement().attribute("param");
            plugin->rip.silent_param = node.toElement().attribute("silent_param");
            plugin->rip.out_file = node.toElement().attribute("out_file");
            plugin->rip.track = node.toElement().attribute("track");
            plugin->rip.device = node.toElement().attribute("device");
            plugin->rip.overwrite = node.toElement().attribute("overwrite");
            plugin->rip.output = node.toElement().attribute("output");

            sub1Node = node.toElement().firstChild();
            while( !sub1Node.isNull() ) {
                if( sub1Node.isElement() && sub1Node.nodeName() == "full_disc" ) {

                    if( sub1Node.toElement().attribute("enabled") == "true" ) plugin->rip.full_disc.enabled = true;
                    else plugin->rip.full_disc.enabled = false;
                    plugin->rip.full_disc.param = sub1Node.toElement().attribute("param");
                    plugin->rip.full_disc.output = sub1Node.toElement().attribute("output");

                }
                sub1Node = sub1Node.nextSibling();
            }
        }
        node = node.nextSibling();
    }

    return plugin;
}

#include "ripperpluginloader.moc"
